/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.pdc.pdc.model.AxisHeaderI18N;
import org.silverpeas.core.persistence.jdbc.DBUtil;

@Repository
public class AxisHeaderI18NDAO {
    private static String pdcAxisI18NTable = "SB_Pdc_AxisI18N";
    private static final String COLUMNS = "id,AxisId,Lang,Name,Description";

    protected AxisHeaderI18NDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AxisHeaderI18N> getTranslations(Connection con, String axisId) throws SQLException {
        String selectQuery = "select * from " + pdcAxisI18NTable + " where AxisId = ?";
        ArrayList<AxisHeaderI18N> allTranslations = new ArrayList<AxisHeaderI18N>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(selectQuery);
            prepStmt.setInt(1, Integer.parseInt(axisId));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                AxisHeaderI18N translation = new AxisHeaderI18N();
                translation.setId(String.valueOf(rs.getInt(1)));
                translation.setObjectId(Integer.toString(rs.getInt(2)));
                translation.setLanguage(rs.getString(3));
                translation.setName(rs.getString(4));
                translation.setDescription(rs.getString(5));
                allTranslations.add(translation);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return allTranslations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTranslation(Connection con, AxisHeaderI18N translation) throws SQLException {
        String selectQuery = "insert into " + pdcAxisI18NTable + "(id,AxisId,Lang,Name,Description) values  (?, ?, ?, ?, ?)";
        PreparedStatement prepStmt = null;
        int id = -1;
        try {
            prepStmt = con.prepareStatement(selectQuery);
            id = DBUtil.getNextId((String)pdcAxisI18NTable, (String)"id");
            prepStmt.setInt(1, id);
            prepStmt.setInt(2, Integer.parseInt(translation.getObjectId()));
            prepStmt.setString(3, translation.getLanguage());
            prepStmt.setString(4, translation.getName());
            prepStmt.setString(5, translation.getDescription());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTranslation(Connection con, AxisHeaderI18N translation) throws SQLException {
        String selectQuery = "update " + pdcAxisI18NTable + " set name = ?, description = ? where id = ? ";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(selectQuery);
            prepStmt.setString(1, translation.getName());
            prepStmt.setString(2, translation.getDescription());
            prepStmt.setInt(3, Integer.parseInt(translation.getId()));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close(rs, (Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranslation(Connection con, String translationId) throws SQLException {
        String selectQuery = "delete from " + pdcAxisI18NTable + " where id = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(selectQuery);
            prepStmt.setInt(1, Integer.parseInt(translationId));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranslations(Connection con, String axisId) throws SQLException {
        String selectQuery = "delete from " + pdcAxisI18NTable + " where axisId = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(selectQuery);
            prepStmt.setInt(1, Integer.parseInt(axisId));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }
}

