/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.search.model.SearchResult;

public class GlobalSilverResult
implements Serializable {
    private final SearchResult result;
    private String titleLink = null;
    private String downloadLink = null;
    private String location;
    private boolean exportable = false;
    private boolean viewable = false;
    private boolean previewable = false;
    private boolean versioned = false;
    private boolean selected = false;
    private boolean hasRead = false;
    private int resultId = 0;
    private int hits = -1;
    private String externalUrl = null;
    private boolean isDownloadAllowedForReaders = true;
    private boolean userAllowedToDownloadFile = true;

    public GlobalSilverResult(SearchResult result) {
        this.result = result;
    }

    public String getId() {
        return this.result.getId();
    }

    public String getInstanceId() {
        return this.result.getInstanceId();
    }

    public String getType() {
        return this.result.getType();
    }

    public boolean isLinked() {
        return this.result.isLinkedToAnotherContribution();
    }

    public String getLinkedResourceId() {
        return this.result.getLinkedResourceId();
    }

    public String getCreatorId() {
        return this.result.getCreatorId();
    }

    public boolean isExternalResult() {
        return this.result.isExternalResult();
    }

    public String getAttachmentFilename() {
        return this.result.getAttachmentFilename();
    }

    public Map<String, String> getFormFieldsForFacets() {
        return this.result.getFormFieldsForFacets();
    }

    public String getServerName() {
        return this.result.getServerName();
    }

    public String getTitleLink() {
        return this.titleLink;
    }

    public void setTitleLink(String link) {
        this.titleLink = link;
    }

    public String getDownloadLink() {
        return this.downloadLink;
    }

    public void setDownloadLink(String link) {
        this.downloadLink = link;
    }

    public String getCreatorName() {
        User user = User.getById((String)this.getCreatorId());
        if (user == null) {
            return "";
        }
        return user.getDisplayedName();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public void setExportable(boolean exportable) {
        this.exportable = exportable;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isHasRead() {
        return this.hasRead;
    }

    public void setHasRead(boolean hasRead) {
        this.hasRead = hasRead;
    }

    public int getResultId() {
        return this.resultId;
    }

    public void setResultId(int resultId) {
        this.resultId = resultId;
    }

    public void setHits(int hits) {
        this.hits = hits;
    }

    public int getHits() {
        return this.hits;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public void setViewable(boolean viewable) {
        this.viewable = viewable;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public void setPreviewable(boolean previewable) {
        this.previewable = previewable;
    }

    public boolean isPreviewable() {
        return this.previewable;
    }

    public String getAttachmentId() {
        return this.isAttachment() ? this.getId() : "";
    }

    public String getAttachmentLanguage() {
        String type = this.getType();
        int idx = type.indexOf(95);
        return idx != -1 ? type.substring(idx + 1) : I18NHelper.DEFAULT_LANGUAGE;
    }

    public void setVersioned(boolean versioned) {
        this.versioned = versioned;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isAttachment() {
        return this.getType().startsWith("Attachment") || this.getType().startsWith("Versioning");
    }

    public boolean isUserAllowedToDownloadFile() {
        return this.userAllowedToDownloadFile;
    }

    public void setUserAllowedToDownloadFile(boolean userAllowedToDownloadFile) {
        this.userAllowedToDownloadFile = userAllowedToDownloadFile;
    }

    public boolean isDownloadAllowedForReaders() {
        return this.isDownloadAllowedForReaders;
    }

    public void setDownloadAllowedForReaders(boolean isDownloadAllowedForReaders) {
        this.isDownloadAllowedForReaders = isDownloadAllowedForReaders;
    }

    public void setName(String name) {
        this.result.setName(name);
    }

    public String getName() {
        return this.result.getName();
    }

    public String getDescription() {
        return this.result.getDescription();
    }

    public String getName(String lang) {
        return this.result.getName(lang);
    }

    public String getDescription(String lang) {
        return this.result.getDescription(lang);
    }

    public String getThumbnailURL() {
        return this.result.getThumbnailURL();
    }

    public void setThumbnailURL(String url) {
        this.result.setThumbnailURL(url);
    }

    public float getScore() {
        return this.result.getScore();
    }

    public LocalDate getCreationDate() {
        return this.result.getCreationLocalDate();
    }

    public LocalDate getLastUpdateDate() {
        return this.result.getLastUpdateLocalDate();
    }

    public String getSpaceId() {
        return "";
    }

    public boolean isAlias() {
        return this.result.isAlias();
    }

    public boolean isNew() {
        return this.result.isNew();
    }

    public boolean equals(Object other) {
        if (!(other instanceof GlobalSilverResult)) {
            return false;
        }
        return this.getId().equals(((GlobalSilverResult)other).getId()) && this.getInstanceId().equals(((GlobalSilverResult)other).getInstanceId());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.getId() != null ? this.getId().hashCode() : 0);
        hash = 29 * hash + (this.getInstanceId() != null ? this.getInstanceId().hashCode() : 0);
        return hash;
    }
}

