/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.wbe;

import java.io.IOException;
import java.util.Enumeration;
import javax.enterprise.event.Observes;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.silverpeas.core.security.session.SilverpeasUserSession;
import org.silverpeas.core.wbe.DefaultWbeUser;
import org.silverpeas.core.wbe.WbeHostManager;
import org.silverpeas.core.wbe.WbeLogger;
import org.silverpeas.core.wbe.WbeUser;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.session.UserSessionEvent;
import org.silverpeas.kernel.logging.Level;

public class WbeFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            boolean debug = WbeLogger.logger().isLoggable(Level.DEBUG);
            if (debug) {
                HttpRequest httpRequest = HttpRequest.decorate((ServletRequest)request);
                Enumeration headerNames = httpRequest.getHeaderNames();
                StringBuilder sb = new StringBuilder();
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    sb.append(headerName).append("=").append(httpRequest.getHeader(headerName)).append("\n");
                }
                Enumeration parameterNames = httpRequest.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String parameterName = (String)parameterNames.nextElement();
                    sb.append(parameterName).append("=").append(httpRequest.getParameter(parameterName)).append("\n");
                }
                WbeLogger.logger().debug("handling {0} on {1} from WBE host {2}:{3}", new Object[]{httpRequest.getMethod(), httpRequest.getRequestURI(), httpRequest.getRemoteHost(), String.valueOf(httpRequest.getRemotePort())});
                WbeLogger.logger().debug("with headers and parameters:\n{0}", new Object[]{sb});
            }
            chain.doFilter(request, response);
            if (httpResponse.getStatus() >= 400) {
                WbeLogger.logger().error("error {0} - {1}", new Object[]{httpResponse.getStatus(), Response.Status.fromStatusCode((int)httpResponse.getStatus())});
            } else if (debug) {
                WbeLogger.logger().debug("status {0} - {1}", new Object[]{httpResponse.getStatus(), Response.Status.fromStatusCode((int)httpResponse.getStatus())});
            }
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void onEvent(@Observes UserSessionEvent userSessionEvent) {
        if (userSessionEvent.isClosing()) {
            DefaultWbeUser user = new DefaultWbeUser((SilverpeasUserSession)userSessionEvent.getSessionInfo());
            WbeHostManager.get().revokeUser((WbeUser)user);
        }
    }
}

