/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.util.logging;

import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.util.logging.AbstractLoggingResource;
import org.silverpeas.core.webapi.util.logging.LoggerConfigurationEntity;
import org.silverpeas.kernel.logging.LoggerConfigurationManager;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.logging.SilverLoggerProvider;

@WebService
@Path(value="logging/{logger}/configuration")
@Authenticated
public class SilverLoggerConfigurationResource
extends AbstractLoggingResource {
    static final String LOGGING_PATH = "logging";
    @PathParam(value="logger")
    private String namespace;

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public LoggerConfigurationEntity changeLoggerConfiguration(LoggerConfigurationEntity config) {
        LoggerConfigurationManager configManager = SilverLoggerProvider.getInstance().getConfigurationManager();
        if (!this.namespace.equals(config.getLogger())) {
            throw new WebApplicationException("The module name of the configuration doesn't match with the URI", Response.Status.BAD_REQUEST);
        }
        LoggerConfigurationManager.LoggerConfiguration loggerConfig = config.toLoggerConfiguration();
        configManager.saveLoggerConfiguration(loggerConfig);
        SilverLogger.getLogger((String)this.namespace).setLevel(loggerConfig.getLevel());
        return LoggerConfigurationEntity.toWebEntity(configManager.getLoggerConfiguration(this.namespace)).withAsURi(this.getUri().getRequestUri());
    }

    protected String getResourceBasePath() {
        return LOGGING_PATH;
    }
}

