/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.util;

import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.web.SilverpeasWebResource;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UserEntity
implements Serializable {
    @XmlElement(required=true)
    private URI uri;
    @XmlElement(required=true)
    private String id;
    @XmlElement(defaultValue="")
    private String firstName;
    @XmlElement(defaultValue="")
    private String lastName;
    @XmlElement(defaultValue="")
    private String fullName;

    protected UserEntity() {
    }

    public UserEntity(User user) {
        this.uri = SilverpeasWebResource.getBasePathBuilder().path("profile/users").path(user.getId()).build(new Object[0]);
        this.id = user.getId();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.fullName = user.getDisplayedName();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserEntity that = (UserEntity)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.id, that.id) && Objects.equals(this.firstName, that.firstName) && Objects.equals(this.lastName, that.lastName) && Objects.equals(this.fullName, that.fullName);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.id, this.firstName, this.lastName, this.fullName);
    }
}

