/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.sharing;

import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.model.TicketFactory;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.kernel.util.StringUtil;

public class TicketEntity
implements WebEntity {
    private static final long serialVersionUID = -3181971971218136594L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement
    @NotNull
    protected String componentId;
    @XmlElement
    @NotNull
    protected String sharedObjectType;
    @XmlElement
    @NotNull
    protected long sharedObjectId;
    @XmlElement
    protected String creatorId;
    @XmlElement
    protected Long creationDate;
    @XmlElement
    protected String updaterId;
    @XmlElement
    protected Long updateDate;
    @XmlElement
    protected String validity;
    @XmlElement
    protected Long endDate;
    @XmlElement
    protected String endDateStr = null;
    @XmlElement
    protected String endDateFormat = null;
    @XmlElement
    @NotNull
    protected int nbAccessMax;
    @XmlElement
    protected int nbAccess;
    @XmlElement(defaultValue="")
    protected String token;
    @XmlElement(defaultValue="")
    protected String url;
    @XmlElement(defaultValue="")
    protected String users;
    @XmlElement(defaultValue="")
    protected String externalEmails;
    @XmlElement(defaultValue="")
    protected String additionalMessage;

    protected TicketEntity() {
    }

    public TicketEntity(Ticket ticket, URI uri) {
        this.uri = uri;
        this.componentId = ticket.getComponentId();
        this.sharedObjectId = ticket.getSharedObjectId();
        this.sharedObjectType = ticket.getSharedObjectType();
        this.token = ticket.getToken();
        this.creationDate = ticket.getCreationDate().getTime();
        this.creatorId = ticket.getCreatorId();
        if (ticket.getEndDate() != null) {
            this.endDate = ticket.getEndDate().getTime();
        }
        this.nbAccess = ticket.getNbAccess();
        this.nbAccessMax = ticket.getNbAccessMax();
        if (ticket.getUpdateDate() != null) {
            this.updateDate = ticket.getUpdateDate().getTime();
        }
        this.updaterId = ticket.getLastModifier();
    }

    public static TicketEntity fromTicket(Ticket ticket, URI uri) {
        return new TicketEntity(ticket, uri);
    }

    public Ticket toTicket(UserDetail user) throws ParseException {
        Ticket ticket;
        Long theSharedObjectId = this.sharedObjectId;
        if ("1".equals(this.validity)) {
            Date theEndDate = DateUtil.getEndOfDay((Date)DateUtil.stringToDate((String)this.endDateStr, (String)user.getUserPreferences().getLanguage()));
            int maxAccessNb = this.nbAccessMax;
            ticket = TicketFactory.aTicket((int)theSharedObjectId.intValue(), (String)this.componentId, (String)user.getId(), (Date)new Date(), (Date)theEndDate, (int)maxAccessNb, (String)this.sharedObjectType);
        } else {
            ticket = TicketFactory.continuousTicket((int)theSharedObjectId.intValue(), (String)this.componentId, (String)user.getId(), (Date)new Date(), (String)this.sharedObjectType);
        }
        return ticket;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getSharedObjectType() {
        return this.sharedObjectType;
    }

    public void setSharedObjectType(String sharedObjectType) {
        this.sharedObjectType = sharedObjectType;
    }

    public long getSharedObjectId() {
        return this.sharedObjectId;
    }

    public void setSharedObjectId(long sharedObjectId) {
        this.sharedObjectId = sharedObjectId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public String getUpdaterId() {
        return this.updaterId;
    }

    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    public Long getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Long updateDate) {
        this.updateDate = updateDate;
    }

    public String getValidity() {
        return this.validity;
    }

    public void setValidity(String validity) {
        this.validity = validity;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public String getEndDateStr() {
        return this.endDateStr;
    }

    public void setEndDateStr(String endDateStr) {
        this.endDateStr = endDateStr;
    }

    public String getEndDateFormat() {
        return this.endDateFormat;
    }

    public void setEndDateFormat(String endDateFormat) {
        this.endDateFormat = endDateFormat;
    }

    public int getNbAccessMax() {
        return this.nbAccessMax;
    }

    public void setNbAccessMax(int nbAccessMax) {
        this.nbAccessMax = nbAccessMax;
    }

    public int getNbAccess() {
        return this.nbAccess;
    }

    public void setNbAccess(int nbAccess) {
        this.nbAccess = nbAccess;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getUsers() {
        return this.users;
    }

    public void setUsers(String users) {
        this.users = users;
    }

    public String getExternalEmails() {
        return this.externalEmails;
    }

    public void setExternalEmails(String externalEmails) {
        this.externalEmails = externalEmails;
    }

    public String getAdditionalMessage() {
        return this.additionalMessage;
    }

    public void setAdditionalMessage(String additionalMessage) {
        this.additionalMessage = additionalMessage;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isValid() {
        if (StringUtil.isDefined((String)this.getToken())) {
            boolean isValid = true;
            if (this.getEndDate() != null) {
                boolean bl = isValid = this.getEndDate().compareTo(new Date().getTime()) < 0;
            }
            if (this.getNbAccessMax() > 0) {
                isValid &= this.getNbAccess() < this.getNbAccessMax();
            }
            return isValid;
        }
        return false;
    }

    public boolean isModified() {
        return this.updateDate != null && StringUtil.isDefined((String)this.updaterId);
    }

    public boolean isContinuous() {
        return this.nbAccessMax <= 0 && this.endDate == null;
    }

    public void setContinuous() {
        this.endDate = null;
        this.nbAccessMax = 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.token != null ? this.token.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketEntity other = (TicketEntity)obj;
        return this.token == other.token || this.token != null && this.token.equals(other.token);
    }

    public URI getURI() {
        return this.uri;
    }
}

