/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.reminder;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.ApplicationService;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.cache.service.VolatileCacheServiceProvider;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.ContributionLocalizationBundle;
import org.silverpeas.core.contribution.model.ContributionModel;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.reminder.DateTimeReminder;
import org.silverpeas.core.reminder.DurationReminder;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.reminder.ReminderProcessName;
import org.silverpeas.core.reminder.ReminderSettings;
import org.silverpeas.core.web.mvc.webcomponent.WebMessager;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.reminder.ReminderEntity;
import org.silverpeas.core.webapi.reminder.ReminderResourceURIs;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="reminder/{componentInstanceId}/{type}/{localId}")
@Authenticated
public class ReminderResource
extends RESTWebService {
    private static final Function<Pair<Integer, TimeUnit>, String> DURATION_IDS = r -> String.valueOf(r.getLeft()) + String.valueOf(r.getRight());
    @Inject
    private ReminderResourceURIs uri;
    @PathParam(value="componentInstanceId")
    private String componentInstanceId;
    @PathParam(value="type")
    private String type;
    @PathParam(value="localId")
    private String localId;

    @Path(value="possibledurations/{property}")
    @GET
    @Produces(value={"application/json"})
    public List<String> getPossibleDurations(@PathParam(value="property") String contributionProperty) {
        if (VolatileCacheServiceProvider.getSessionVolatileResourceCacheService().contains(this.localId, this.componentInstanceId)) {
            return ReminderSettings.getPossibleReminders().map(DURATION_IDS).collect(Collectors.toList());
        }
        ContributionModel model = this.getContribution().getModel();
        ZoneId userZoneId = this.getUserPreferences().getZoneId();
        ZoneId platformZoneId = ZoneId.systemDefault();
        Mutable lastMatchOk = Mutable.of((Object)true);
        return ReminderSettings.getPossibleReminders().filter(r -> {
            if (lastMatchOk.is((Object)false)) {
                return false;
            }
            ZonedDateTime from = ZonedDateTime.now(userZoneId).plus(((Integer)r.getLeft()).intValue(), ((TimeUnit)r.getRight()).toChronoUnit());
            ZonedDateTime dateReference = model.filterByType(contributionProperty, new Object[]{from}).matchFirst(Date.class::isAssignableFrom, d -> ZonedDateTime.ofInstant(((Date)d).toInstant(), platformZoneId)).matchFirst(OffsetDateTime.class::equals, d -> ((OffsetDateTime)d).atZoneSameInstant(platformZoneId)).matchFirst(LocalDate.class::equals, d -> ((LocalDate)d).atStartOfDay(userZoneId).withZoneSameInstant(platformZoneId)).matchFirst(LocalDateTime.class::equals, d -> ((LocalDateTime)d).atZone(platformZoneId)).matchFirst(ZonedDateTime.class::equals, d -> ((ZonedDateTime)d).withZoneSameInstant(platformZoneId)).result().orElse(null);
            lastMatchOk.set((Object)(dateReference != null ? 1 : 0));
            return (Boolean)lastMatchOk.get();
        }).map(DURATION_IDS).collect(Collectors.toList());
    }

    @GET
    @Produces(value={"application/json"})
    public List<ReminderEntity> getReminders() {
        List reminders = Reminder.getByContributionAndUser((ContributionIdentifier)this.getContributionIdentifier(), (User)this.getUser());
        return this.asWebEntities(reminders);
    }

    @POST
    @Produces(value={"application/json"})
    public ReminderEntity createReminder(ReminderEntity reminderEntity) {
        Contribution contribution = this.getContribution();
        ReminderProcessName processName = ReminderProcessName.getByName((String)reminderEntity.getProcessName());
        Object reminder = StringUtil.isDefined((String)reminderEntity.getDateTime()) ? new DateTimeReminder(this.getContributionIdentifier(), this.getUser(), processName) : new DurationReminder(this.getContributionIdentifier(), this.getUser(), processName);
        reminderEntity.mergeInto((Reminder)reminder);
        try {
            reminder.schedule();
        }
        catch (AssertionError e) {
            this.errorMessage("reminder.add.duration.error", this.getReminderLabel(reminderEntity), this.getUiMessageContributionLabel(reminderEntity, contribution));
            throw new WebApplicationException((Throwable)((Object)e), Response.Status.PRECONDITION_FAILED);
        }
        if (reminder instanceof DurationReminder) {
            this.successMessage("reminder.add.duration.success", this.getReminderLabel(reminderEntity), this.getUiMessageContributionLabel(reminderEntity, contribution));
        }
        return this.asWebEntity((Reminder)reminder);
    }

    @Path(value="{id}")
    @PUT
    @Produces(value={"application/json"})
    public ReminderEntity updateReminder(@PathParam(value="id") String id, ReminderEntity reminderEntity) {
        Contribution contribution = this.getContribution();
        Reminder reminder = Reminder.getByContributionAndUser((ContributionIdentifier)this.getContributionIdentifier(), (User)this.getUser()).stream().filter(r -> r.getId().equals(id)).findFirst().orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
        reminderEntity.mergeInto(reminder);
        try {
            reminder.schedule();
        }
        catch (AssertionError e) {
            this.errorMessage("reminder.update.duration.error", this.getReminderLabel(reminderEntity), this.getUiMessageContributionLabel(reminderEntity, contribution));
            throw new WebApplicationException((Throwable)((Object)e), Response.Status.PRECONDITION_FAILED);
        }
        if (reminder instanceof DurationReminder) {
            this.successMessage("reminder.update.duration.success", this.getReminderLabel(reminderEntity), this.getUiMessageContributionLabel(reminderEntity, contribution));
        }
        return this.asWebEntity(reminder);
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public void deleteReminder(@PathParam(value="id") String id) {
        Contribution contribution = this.getContribution();
        Reminder reminder = Reminder.getByContributionAndUser((ContributionIdentifier)this.getContributionIdentifier(), (User)this.getUser()).stream().filter(r -> r.getId().equals(id)).findFirst().orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
        reminder.unschedule();
        if (reminder instanceof DurationReminder) {
            this.successMessage("reminder.delete.success", this.getUiMessageContributionLabel(this.asWebEntity(reminder), contribution));
        }
    }

    protected String getResourceBasePath() {
        return "reminder";
    }

    public String getComponentId() {
        return this.componentInstanceId;
    }

    private List<ReminderEntity> asWebEntities(Collection<Reminder> reminders) {
        return reminders.stream().map(this::asWebEntity).collect(Collectors.toList());
    }

    private ReminderEntity asWebEntity(Reminder reminder) {
        return ReminderEntity.fromReminder(reminder).withURI(this.uri.ofReminder(reminder));
    }

    private ContributionIdentifier getContributionIdentifier() {
        return ContributionIdentifier.from((String)this.getComponentId(), (String)this.localId, (String)this.type);
    }

    private Contribution getContribution() {
        ContributionIdentifier id = this.getContributionIdentifier();
        Contribution contribution = (Contribution)ApplicationService.getInstance((String)id.getComponentInstanceId()).getContributionById(id).orElseThrow(() -> new WebApplicationException(SilverpeasExceptionMessages.failureOnGetting((String)"contribution", (Object)this.getContributionIdentifier().asString()), Response.Status.NOT_FOUND));
        if (!contribution.canBeAccessedBy(this.getUser())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return contribution;
    }

    private String getUiMessageContributionLabel(ReminderEntity reminder, Contribution contribution) {
        ContributionLocalizationBundle bundle = ContributionLocalizationBundle.getByInstanceAndLanguage((Contribution)contribution, (String)this.getUserPreferences().getLanguage());
        if (StringUtil.isNotDefined((String)reminder.getDateTime())) {
            return bundle.getUiMessageTitleByTypeAndProperty(reminder.getcProperty());
        }
        return bundle.getUiMessageTitleByType();
    }

    private String getReminderLabel(ReminderEntity reminder) {
        if (StringUtil.isNotDefined((String)reminder.getDateTime())) {
            LocalizationBundle localizedUnits = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.multilang.util", (String)this.getUserPreferences().getLanguage());
            return localizedUnits.getStringWithParams(String.valueOf(reminder.getTimeUnit()) + ".precise", new Object[]{reminder.getDuration()});
        }
        return null;
    }

    private void successMessage(String messageKey, Object ... params) {
        this.getMessager().addSuccess(ReminderSettings.getMessagesIn((String)this.getUserPreferences().getLanguage()).getString(messageKey), params);
    }

    private void errorMessage(String messageKey, Object ... params) {
        this.getMessager().addError(ReminderSettings.getMessagesIn((String)this.getUserPreferences().getLanguage()).getString(messageKey), params);
    }

    private WebMessager getMessager() {
        return WebMessager.getInstance();
    }
}

