/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.node;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.i18n.BeanTranslation;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.node.NodeAttrEntity;
import org.silverpeas.core.webapi.node.NodeStateEntity;
import org.silverpeas.core.webapi.node.NodeTranslationEntity;
import org.silverpeas.core.webapi.node.NodeType;
import org.silverpeas.kernel.logging.SilverLogger;

@XmlRootElement
public class NodeEntity
implements WebEntity {
    private static final long serialVersionUID = -5740937039604775733L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(defaultValue="")
    private String id;
    @XmlElement(required=true)
    private String text;
    @XmlElement(defaultValue="folder")
    private NodeType type = NodeType.FOLDER;
    @XmlElement
    private NodeEntity[] children;
    @XmlElement(required=true)
    private NodeAttrEntity attr;
    @XmlElement
    private NodeTranslationEntity[] translations;
    @XmlElement
    private NodeStateEntity state = new NodeStateEntity();
    @XmlElement(defaultValue="")
    private URI childrenURI;

    public NodeEntity() {
    }

    public static NodeEntity fromNodeDetail(SilverpeasRole highestComponentUserRole, NodeDetail node, URI uri) {
        return new NodeEntity(highestComponentUserRole, node, uri, null);
    }

    public static NodeEntity fromNodeDetail(SilverpeasRole highestComponentUserRole, NodeDetail node, URI uri, String lang) {
        return new NodeEntity(highestComponentUserRole, node, uri, lang);
    }

    public static NodeEntity fromNodeDetail(SilverpeasRole highestComponentUserRole, NodeDetail node, String uri) {
        return NodeEntity.fromNodeDetail(highestComponentUserRole, node, NodeEntity.getURI(uri), null);
    }

    public static NodeEntity fromNodeDetail(SilverpeasRole highestComponentUserRole, NodeDetail node, String uri, String lang) {
        return NodeEntity.fromNodeDetail(highestComponentUserRole, node, NodeEntity.getURI(uri), lang);
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    private NodeEntity(SilverpeasRole highestComponentUserRole, NodeDetail node, URI uri, String lang) {
        this.text = Encode.forHtml((String)node.getName(lang));
        this.uri = uri;
        this.id = node.getNodePK().getId();
        this.attr = NodeAttrEntity.fromNodeDetail(node, uri, lang);
        if (this.getAttr().isSpecificRights() && (SilverpeasRole.ADMIN == highestComponentUserRole || SilverpeasRole.ADMIN.getName().equals(this.getAttr().getRole()))) {
            this.type = NodeType.FOLDER_WITH_RIGHTS;
        }
        Map theTranslations = node.getTranslations();
        ArrayList<NodeTranslationEntity> translationEntities = new ArrayList<NodeTranslationEntity>();
        for (BeanTranslation translation : theTranslations.values()) {
            NodeTranslationEntity translationEntity = new NodeTranslationEntity(translation.getId(), translation.getLanguage(), node);
            translationEntities.add(translationEntity);
        }
        this.translations = translationEntities.toArray(new NodeTranslationEntity[0]);
        this.setChildrenURI(this.getChildrenURI(uri));
        if (node.getChildrenDetails() != null) {
            ArrayList<NodeEntity> entities = new ArrayList<NodeEntity>();
            for (NodeDetail child : node.getChildrenDetails()) {
                URI childURI = this.getChildURI(uri, child.getNodePK().getId());
                NodeEntity childEntity = NodeEntity.fromNodeDetail(highestComponentUserRole, child, childURI, lang);
                childEntity.setChildrenURI(this.getChildrenURI(childURI));
                entities.add(childEntity);
            }
            this.children = entities.toArray(new NodeEntity[0]);
        }
    }

    private URI getChildURI(URI parentURI, String childId) {
        try {
            return new URI(String.valueOf(parentURI) + "/" + childId);
        }
        catch (URISyntaxException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static URI getURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            SilverLogger.getLogger(NodeEntity.class).error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void setChildren(NodeEntity[] children) {
        this.children = (NodeEntity[])children.clone();
    }

    public NodeEntity[] getChildren() {
        return this.children;
    }

    public final void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public NodeType getType() {
        return this.type;
    }

    public final void setType(NodeType type) {
        this.type = type;
    }

    public final void setAttr(NodeAttrEntity attr) {
        this.attr = attr;
    }

    public NodeAttrEntity getAttr() {
        return this.attr;
    }

    public void setState(NodeStateEntity state) {
        this.state = state;
    }

    public NodeStateEntity getState() {
        return this.state;
    }

    public final void setChildrenURI(URI childrenURI) {
        this.childrenURI = childrenURI;
        this.attr.setChildrenURI(childrenURI);
    }

    public final URI getChildrenURI(URI uri) {
        try {
            return new URI(String.valueOf(uri) + "/children");
        }
        catch (URISyntaxException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public URI getChildrenURI() {
        return this.childrenURI;
    }

    public final void setTranslations(NodeTranslationEntity[] translations) {
        this.translations = translations != null ? (NodeTranslationEntity[])translations.clone() : null;
    }

    public NodeTranslationEntity[] getTranslations() {
        return this.translations;
    }

    public NodePK toNodePK() {
        NodePK nodePk = new NodePK(this.attr.getId(), this.attr.getComponentId());
        return nodePk;
    }
}

