/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.comment;

import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.comment.model.CommentId;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.profile.ProfileResourceBaseURIs;
import org.silverpeas.core.webapi.profile.UserProfileEntity;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CommentEntity
implements WebEntity {
    private static final long serialVersionUID = 8023645204584179638L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(defaultValue="")
    private String id;
    @XmlElement(required=true)
    @NotNull
    @Size(min=2)
    private @NotNull @Size(min=2) String componentId;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String resourceType;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String resourceId;
    @XmlElement(required=true)
    @NotNull
    private String text;
    @XmlElement(required=true)
    @NotNull
    private UserProfileEntity author;
    private String currentUserLanguage;
    @XmlElement(required=true, defaultValue="")
    private String creationDate;
    @XmlElement(required=true, defaultValue="")
    private String modificationDate;
    @XmlElement
    private boolean indexed = false;

    public static CommentEntity fromComment(Comment comment) {
        return new CommentEntity(comment);
    }

    public Comment toComment() {
        CommentId commentId = new CommentId(this.getComponentId(), this.getId());
        ResourceReference resourceRef = new ResourceReference(this.getResourceId(), this.getComponentId());
        Date authoredDate = CommentEntity.decodeFromDisplayDate(this.getCreationDate(), this.getCurrentUserLanguage());
        Date updateDate = CommentEntity.decodeFromDisplayDate(this.getModificationDate(), this.getCurrentUserLanguage());
        Comment comment = new Comment(commentId, this.getAuthor().getId(), this.getResourceType(), resourceRef, authoredDate);
        comment.setLastUpdateDate(updateDate);
        comment.setMessage(this.getText());
        return comment;
    }

    public CommentEntity withURI(URI uri) {
        this.uri = uri;
        String baseURI = uri.toString();
        String usersURI = baseURI.substring(0, baseURI.indexOf("comments")) + "profile/users";
        this.author = this.author.withAsUri(ProfileResourceBaseURIs.uriOfUser(this.author, usersURI));
        return this;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public UserProfileEntity getAuthor() {
        return this.author;
    }

    public String getText() {
        return this.text;
    }

    public String getCurrentUserLanguage() {
        return this.currentUserLanguage;
    }

    public CommentEntity withCurrentUserLanguage(String currentUserLanguage) {
        this.currentUserLanguage = currentUserLanguage;
        Date createDate = CommentEntity.decodeFromDisplayDate(this.getCreationDate(), I18NHelper.DEFAULT_LANGUAGE);
        this.creationDate = CommentEntity.encodeToDisplayDate(createDate, this.currentUserLanguage);
        Date updateDate = CommentEntity.decodeFromDisplayDate(this.getModificationDate(), I18NHelper.DEFAULT_LANGUAGE);
        this.modificationDate = CommentEntity.encodeToDisplayDate(updateDate, this.currentUserLanguage);
        return this;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getModificationDate() {
        return this.modificationDate;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    protected CommentEntity(Comment comment) {
        this.componentId = comment.getIdentifier().getComponentInstanceId();
        this.id = comment.getIdentifier().getLocalId();
        this.resourceType = comment.getResourceType();
        this.resourceId = comment.getResourceReference().getLocalId();
        this.text = comment.getMessage();
        this.author = UserProfileEntity.fromUser(comment.getCreator());
        this.creationDate = CommentEntity.encodeToDisplayDate(comment.getCreationDate(), I18NHelper.DEFAULT_LANGUAGE);
        this.modificationDate = CommentEntity.encodeToDisplayDate(comment.getLastUpdateDate(), I18NHelper.DEFAULT_LANGUAGE);
        this.indexed = comment.isIndexable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommentEntity that = (CommentEntity)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.id, that.id) && Objects.equals(this.componentId, that.componentId) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.text, that.text) && Objects.equals((Object)this.author, (Object)that.author) && Objects.equals(this.currentUserLanguage, that.currentUserLanguage) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.modificationDate, that.modificationDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.id, this.componentId, this.resourceType, this.resourceId, this.text, this.author, this.currentUserLanguage, this.creationDate, this.modificationDate, this.indexed});
    }

    protected CommentEntity() {
    }

    private static String encodeToDisplayDate(Date date, String language) {
        String displayDate = DateUtil.getOutputDate((Date)Objects.requireNonNullElseGet(date, Date::new), (String)language);
        return displayDate;
    }

    private static Date decodeFromDisplayDate(String displayDate, String language) {
        Date date = new Date();
        if (StringUtil.isDefined((String)displayDate)) {
            try {
                String sqlDate = DateUtil.date2SQLDate((String)displayDate, (String)language);
                date = DateUtil.parseDate((String)sqlDate);
            }
            catch (ParseException ex) {
                SilverLogger.getLogger(CommentEntity.class).warn((Throwable)ex);
            }
        }
        return date;
    }
}

