/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.pagination;

import org.silverpeas.core.admin.PaginationPage;

public class PaginationUtil {
    private PaginationUtil() {
    }

    public static String formatFromFirstIndexOfItem(int nbItemsPerPage, int totalNumberOfItems, int firstItemIndexOfCurrentPage) {
        StringBuilder result = new StringBuilder();
        if (totalNumberOfItems <= firstItemIndexOfCurrentPage || totalNumberOfItems <= nbItemsPerPage) {
            result.append(totalNumberOfItems).append(" ");
        } else {
            int end = firstItemIndexOfCurrentPage + nbItemsPerPage;
            if (end > totalNumberOfItems) {
                end = totalNumberOfItems;
            }
            result.append(firstItemIndexOfCurrentPage + 1).append(" - ").append(end).append(" / ").append(totalNumberOfItems).append(" ");
        }
        return result.toString();
    }

    public static String formatFromFirstIndexOfItem(PaginationPage paginationPage, int totalNumberOfItems) {
        int firstIndex = (paginationPage.getPageNumber() - 1) * paginationPage.getPageSize();
        return PaginationUtil.formatFromFirstIndexOfItem(paginationPage.getPageSize(), totalNumberOfItems, firstIndex);
    }
}

