/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.browsebars;

import java.util.Optional;
import javax.servlet.jsp.JspException;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.core.web.mvc.webcomponent.NavigationContext;
import org.silverpeas.core.web.util.viewgenerator.html.NeedWindowTag;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBar;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBarElement;
import org.silverpeas.core.web.util.viewgenerator.html.window.Window;
import org.silverpeas.kernel.util.StringUtil;

public class BrowseBarTag
extends NeedWindowTag {
    private static final long serialVersionUID = 2496136938371562945L;
    private BrowseBar browseBar;
    private String extraInformations;
    private Object path;
    private String spaceId;
    private String componentId;
    private String componentJsCallback;
    private String spaceJsCallback;
    private boolean ignoreComponentLink = true;
    private boolean clickable = true;

    public void setExtraInformations(String extraInformations) {
        this.extraInformations = extraInformations;
    }

    public void setPath(Object path) {
        this.path = path;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public void setComponentJsCallback(String componentJsCallback) {
        this.componentJsCallback = componentJsCallback;
    }

    public void setIgnoreComponentLink(boolean ignoreComponentLink) {
        this.ignoreComponentLink = ignoreComponentLink;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public void setSpaceJsCallback(String spaceJsCallback) {
        this.spaceJsCallback = spaceJsCallback;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    public void addElement(BrowseBarElement element) {
        this.browseBar.addElement(element);
    }

    public int doStartTag() throws JspException {
        Window window = this.getWindow();
        this.browseBar = window.getBrowseBar();
        this.browseBar.setLook((LookHelper)this.pageContext.getSession().getAttribute("Silverpeas_LookHelper"));
        this.applyExtraInformations();
        this.applyPath();
        this.applyComponentData();
        this.applySpaceData();
        this.browseBar.setIgnoreComponentLink(this.ignoreComponentLink);
        this.browseBar.setClickable(this.clickable);
        this.applyNavigationContextData();
        return 1;
    }

    private void applyNavigationContextData() {
        if (this.path instanceof NavigationContext) {
            for (NavigationContext.NavigationStep currentNavigationStep = ((NavigationContext)this.path).getBaseNavigationStep(); currentNavigationStep != null; currentNavigationStep = currentNavigationStep.getNext()) {
                if (!StringUtil.isDefined((String)currentNavigationStep.getLabel())) continue;
                Object link2 = "#";
                if (currentNavigationStep.isUriMustBeUsedByBrowseBar()) {
                    link2 = URLUtil.getApplicationURL() + currentNavigationStep.getUri().toString().replaceAll("[&]ArrayPaneAction.*", "");
                }
                BrowseBarElement element = new BrowseBarElement(currentNavigationStep.getLabel(), (String)link2, null);
                this.browseBar.addElement(element);
            }
        }
    }

    private void applySpaceData() {
        if (StringUtil.isDefined((String)this.spaceId)) {
            this.browseBar.setSpaceId(this.spaceId);
        }
        if (StringUtil.isDefined((String)this.spaceJsCallback)) {
            this.browseBar.setSpaceJavascriptCallback(this.spaceJsCallback);
        }
    }

    private void applyComponentData() {
        if (StringUtil.isDefined((String)this.componentId)) {
            Optional optionalComponentInstance = SilverpeasComponentInstance.getById((String)this.componentId);
            if (optionalComponentInstance.isPresent()) {
                this.browseBar.setComponentId(this.componentId);
            } else {
                this.browseBar.setComponentName(this.componentId);
            }
            if (StringUtil.isDefined((String)this.componentJsCallback)) {
                this.browseBar.setComponentJavascriptCallback(this.componentJsCallback);
            }
        }
    }

    private void applyPath() {
        if (this.path instanceof String && StringUtil.isDefined((String)this.path.toString())) {
            this.browseBar.setPath(this.path.toString());
        }
    }

    private void applyExtraInformations() {
        if (this.extraInformations != null) {
            this.browseBar.setExtraInformation(this.extraInformations);
        }
    }
}

