/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.servlet;

import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.mvc.controller.SilverpeasWebUtil;
import org.silverpeas.core.web.mvc.util.AccessForbiddenException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class GoTo
extends HttpServlet {
    private static final long serialVersionUID = -8381001443484846645L;
    private static final String MANUAL_JSON_RESPONSE_PREFIX = "MANUAL_JSON_RESPONSE_";
    @Inject
    protected SilverpeasWebUtil util;

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        HttpRequest httpRequest = HttpRequest.decorate((HttpServletRequest)req);
        Context context = new Context(httpRequest, res).init();
        String id = this.getObjectId((HttpServletRequest)httpRequest);
        try {
            Object redirect = this.getDestination(id, context);
            if (!StringUtil.isDefined((String)redirect)) {
                this.objectNotFound(context);
            } else if (!res.isCommitted()) {
                if (((String)redirect).startsWith(MANUAL_JSON_RESPONSE_PREFIX)) {
                    res.setContentType("application/json");
                    res.setCharacterEncoding(Charsets.UTF_8.name());
                    res.getWriter().append(((String)redirect).substring(MANUAL_JSON_RESPONSE_PREFIX.length()));
                    res.flushBuffer();
                    return;
                }
                if (!((String)redirect).startsWith("http")) {
                    redirect = URLUtil.getFullApplicationURL((HttpServletRequest)httpRequest) + "/autoRedirect.jsp?" + (String)redirect;
                }
                UriBuilder uriBuilder = UriBuilder.fromUri((String)redirect).queryParam("fromResponsiveWindow", new Object[]{context.isFromResponsiveWindow()});
                if (context.isForceToLogin()) {
                    uriBuilder.queryParam("forceToLogin", new Object[]{true});
                }
                res.sendRedirect(res.encodeRedirectURL(uriBuilder.build(new Object[0]).toString()));
            }
        }
        catch (AccessForbiddenException afe) {
            this.accessForbidden(context);
        }
        catch (Exception e) {
            this.objectNotFound(context);
        }
    }

    public String getDestination(String objectId, Context context) throws Exception {
        return this.getDestination(objectId, context.getRequest(), context.getResponse());
    }

    public abstract String getDestination(String var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    protected String sendJson(String jsonContent) {
        return MANUAL_JSON_RESPONSE_PREFIX + jsonContent;
    }

    private void objectNotFound(Context context) {
        try {
            if (context.isFromResponsiveWindow()) {
                this.sendJsonResponse(context, JSONCodec.encodeObject(o -> o.put("errorMessage", ResourceLocator.getGeneralLocalizationBundle((String)context.getLanguage()).getString("GML.DocumentNotFound"))));
            } else {
                boolean isLoggedIn = this.isUserLogin(context.getRequest());
                if (!isLoggedIn) {
                    context.getResponse().sendRedirect("/weblib/notFound.html");
                } else {
                    context.getResponse().sendRedirect(URLUtil.getApplicationURL() + "/admin/jsp/documentNotFound.jsp");
                }
            }
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            context.getResponse().setStatus(500);
        }
    }

    private void accessForbidden(Context context) {
        try {
            if (context.isFromResponsiveWindow()) {
                this.sendJsonResponse(context, JSONCodec.encodeObject(o -> o.put("errorMessage", ResourceLocator.getGeneralLocalizationBundle((String)context.getLanguage()).getString("GML.ForbiddenAccessContent"))));
            } else {
                context.getResponse().sendRedirect(URLUtil.getApplicationURL() + "/admin/jsp/accessForbidden.jsp");
            }
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            context.getResponse().setStatus(500);
        }
    }

    private void sendJsonResponse(Context context, String json) throws IOException {
        context.getResponse().setContentType("application/json");
        context.getResponse().getWriter().print(json);
    }

    public String getObjectId(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            return pathInfo.substring(1);
        }
        return null;
    }

    protected boolean isUserLogin(HttpServletRequest req) {
        return this.util.getMainSessionController(req) != null;
    }

    protected boolean isUserAllowed(HttpServletRequest req, String componentId) {
        MainSessionController mainSessionCtrl = this.util.getMainSessionController(req);
        if (componentId == null) {
            return true;
        }
        return OrganizationController.get().isComponentAvailableToUser(componentId, mainSessionCtrl.getUserId());
    }

    public String getUserId(HttpServletRequest req) {
        return this.util.getMainSessionController(req).getUserId();
    }

    protected void setGefSpaceId(HttpServletRequest req, String componentId) {
        if (StringUtil.isDefined((String)componentId)) {
            HttpSession session = req.getSession(true);
            Optional.ofNullable(LookHelper.getLookHelper(session)).ifPresent(h -> h.setComponentIdAndSpaceIds(null, null, componentId));
        }
    }

    protected String getContentLanguage(HttpServletRequest request) {
        return this.util.getContentLanguage(request);
    }

    public static class Context {
        private final HttpRequest request;
        private final HttpServletResponse response;
        private final boolean fromResponsiveWindow;
        private final boolean forceToLogin;
        private final String language;

        private Context(HttpRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
            this.fromResponsiveWindow = request.getParameterAsBoolean("fromResponsiveWindow");
            this.forceToLogin = request.getParameterAsBoolean("forceToLogin");
            this.language = User.getCurrentRequester() != null ? User.getCurrentRequester().getUserPreferences().getLanguage() : DisplayI18NHelper.getDefaultLanguage();
        }

        Context init() {
            return this;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public boolean isFromResponsiveWindow() {
            return this.fromResponsiveWindow;
        }

        public boolean isForceToLogin() {
            return this.forceToLogin;
        }

        public String getLanguage() {
            return this.language;
        }
    }
}

