/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.controller;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.security.authorization.ForbiddenRuntimeException;
import org.silverpeas.core.web.mvc.controller.AbstractComponentSessionController;
import org.silverpeas.core.web.mvc.controller.ComponentContext;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractAdminComponentSessionController
extends AbstractComponentSessionController {
    private static final long serialVersionUID = 866731879572404115L;

    public AbstractAdminComponentSessionController(MainSessionController controller, ComponentContext context, String localizedMessagesBundleName) {
        super(controller, context, localizedMessagesBundleName);
    }

    public AbstractAdminComponentSessionController(MainSessionController controller, ComponentContext context, String localizedMessagesBundleName, String iconFileName) {
        super(controller, context, localizedMessagesBundleName, iconFileName);
    }

    public AbstractAdminComponentSessionController(MainSessionController controller, ComponentContext context, String localizedMessagesBundleName, String iconFileName, String settingsFileName) {
        super(controller, context, localizedMessagesBundleName, iconFileName, settingsFileName);
    }

    @Override
    public void setAppModeMaintenance(boolean mode) {
        this.checkAdminAccessOnly();
        super.setAppModeMaintenance(mode);
    }

    @Override
    public void setSpaceModeMaintenance(String spaceId, boolean mode) {
        if (StringUtil.isDefined((String)spaceId)) {
            this.checkAccessGranted(spaceId, null, false);
        } else {
            this.throwForbiddenError();
        }
        super.setSpaceModeMaintenance(spaceId, mode);
    }

    public boolean isUserAdmin() {
        return this.getUserDetail().isAccessAdmin();
    }

    public void checkAdminAccessOnly() {
        if (!this.isUserAdmin()) {
            this.throwForbiddenError();
        }
    }

    public boolean isAccessGranted() {
        return this.isUserAdmin();
    }

    public void checkAccessGranted() {
        if (!this.isAccessGranted()) {
            this.throwForbiddenError();
        }
    }

    public boolean isAccessGranted(String spaceId, String instanceId, boolean readOnly) throws ForbiddenRuntimeException {
        boolean accessGranted = this.getUserDetail().isAccessAdmin();
        if (!accessGranted) {
            String[] userManageableSpaceIds = this.getUserManageableSpaceIds();
            boolean bl = accessGranted = userManageableSpaceIds.length > 0 && (readOnly || StringUtil.isDefined((String)spaceId) || StringUtil.isDefined((String)instanceId));
            if (accessGranted) {
                Set userManageableSpaceIdSet = Stream.of(userManageableSpaceIds).collect(Collectors.toSet());
                if (StringUtil.isDefined((String)instanceId)) {
                    accessGranted = this.getOrganisationController().getComponentInstance(instanceId).map(SilverpeasComponentInstance::getSpaceId).map(userManageableSpaceIdSet::contains).orElse(false);
                }
                if (accessGranted && StringUtil.isDefined((String)spaceId)) {
                    accessGranted = Optional.ofNullable(this.getOrganisationController().getSpaceInstById(spaceId)).map(SpaceInst::getId).map(s -> {
                        boolean bl;
                        block3: {
                            block2: {
                                if (userManageableSpaceIdSet.contains(s)) break block2;
                                if (!readOnly) break block3;
                                if (!Stream.of(userManageableSpaceIds).map(arg_0 -> ((OrganizationController)this.getOrganisationController()).getSpaceInstById(arg_0)).filter(Objects::nonNull).map(SpaceInst::getDomainFatherId).filter(StringUtil::isDefined).filter(Predicate.not(userManageableSpaceIdSet::contains)).flatMap(m -> this.getOrganisationController().getPathToSpace(m).stream()).map(SpaceInstLight::getId).anyMatch(s::equals)) break block3;
                            }
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }).orElse(false);
                }
            }
        }
        return accessGranted;
    }

    public void checkAccessGranted(String spaceId, String instanceId, boolean readOnly) throws ForbiddenRuntimeException {
        if (!this.isAccessGranted(spaceId, instanceId, readOnly)) {
            this.throwForbiddenError();
        }
    }

    protected void throwForbiddenError() {
        throw new ForbiddenRuntimeException(String.format("Forbidden admin access to user with id %s", this.getUserId()));
    }
}

