/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.http;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.web.http.FileResponse;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.util.StringUtil;

public class PreparedDownload
implements Serializable {
    private static final long serialVersionUID = 4282855362562277729L;
    private static final String PREPARED_DOWNLOAD = "preparedDownload";
    private static final String PREPARED_DOWNLOAD_URL = "preparedDownloadUrl";
    private final String id;
    private final String fileName;
    private final String contentType;
    private String characterEncoding = Charsets.UTF_8.name();

    public PreparedDownload(String fileName, String contentType) {
        this.id = UUID.randomUUID().toString();
        this.fileName = fileName;
        this.contentType = contentType;
    }

    public static Optional<PreparedDownload> getPreparedDownloadToPerform(HttpServletRequest request, String fileName, String contentType) {
        if (StringUtil.getBooleanValue((String)request.getParameter(PREPARED_DOWNLOAD))) {
            return Optional.of(new PreparedDownload(fileName, contentType));
        }
        return Optional.empty();
    }

    public static PreparedDownload getFrom(HttpServletRequest request) {
        String preparedDownloadId = request.getParameter("id");
        if (StringUtil.isNotDefined((String)preparedDownloadId)) {
            throw new IllegalArgumentException("identifier of prepared download MUST exists");
        }
        SimpleCache cache = CacheAccessorProvider.getSessionCacheAccessor().getCache();
        PreparedDownload preparedDownload = (PreparedDownload)cache.remove((Object)(PREPARED_DOWNLOAD + preparedDownloadId), PreparedDownload.class);
        if (preparedDownload == null) {
            throw new IllegalArgumentException("prepared download " + preparedDownloadId + " does not exist anymore");
        }
        return preparedDownload;
    }

    public Writer getWriter(String charset) throws IOException {
        this.characterEncoding = charset;
        if (StringUtil.isNotDefined((String)this.fileName)) {
            throw new IllegalArgumentException("no filename has been specified to prepare the download");
        }
        File file = this.getFile();
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public void sendDetails(HttpServletResponse response) throws IOException {
        String jsonToSend = JSONCodec.encodeObject(o -> o.put(PREPARED_DOWNLOAD_URL, URLUtil.getApplicationURL() + "/PreparedDownload?id=" + this.id));
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charsets.UTF_8.name());
        response.getWriter().append(jsonToSend);
        SimpleCache cache = CacheAccessorProvider.getSessionCacheAccessor().getCache();
        cache.put((Object)(PREPARED_DOWNLOAD + this.id), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTo(HttpServletRequest request, HttpServletResponse response) {
        File file = this.getFile();
        try {
            FileResponse.fromServlet(request, response).forceMimeType(this.contentType).forceCharacterEncoding(this.characterEncoding).forceFileName(this.fileName).noCache().sendPath(Paths.get(file.toURI()));
        }
        finally {
            FileUtils.deleteQuietly((File)file);
        }
    }

    private File getFile() {
        return new File(FileRepositoryManager.getTemporaryPath(), this.id);
    }
}

