/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar.socialnetwork;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Objects;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.VisibilityLevel;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.socialnetwork.model.AbstractSocialInformation;
import org.silverpeas.core.socialnetwork.model.SocialInformationType;

public class CalendarEventOccurrenceSocialInformation
extends AbstractSocialInformation {
    private final String requesterId;
    private final ZoneId userZoneId;
    private final String userOwnerId;
    private final Period period;
    private final CalendarEventOccurrence occurrence;

    public CalendarEventOccurrenceSocialInformation(CalendarEventOccurrence occurrence, OffsetDateTime now, String requesterId, ZoneId userZoneId, String userOwnerId) {
        super(occurrence.getIdentifier().toReference());
        this.requesterId = requesterId;
        this.userZoneId = userZoneId;
        this.userOwnerId = userOwnerId;
        this.occurrence = occurrence;
        this.period = occurrence.getPeriod();
        if (this.period.endsAfter((Temporal)now.atZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC))) {
            this.setType(SocialInformationType.EVENT.toString());
        } else {
            this.setType(SocialInformationType.LASTEVENT.toString());
        }
        this.setUpdated(true);
        this.setUrl("");
    }

    public String getIcon() {
        if (!this.isUpdated() && VisibilityLevel.PRIVATE == this.occurrence.getVisibilityLevel() && this.occurrence.getAttendees().stream().noneMatch(a2 -> a2.getId().equals(this.requesterId))) {
            return this.getType() + "_private.gif";
        }
        return this.getType() + "_public.gif";
    }

    public String getTitle() {
        return this.occurrence.getTitle();
    }

    public String getDescription() {
        return this.occurrence.getDescription();
    }

    public String getAuthor() {
        return this.userOwnerId;
    }

    public Date getDate() {
        Date startDate = super.getDate();
        if (startDate == null) {
            Instant instant = this.period.isInDays() ? TemporalConverter.asLocalDate((Temporal)this.period.getStartDate()).atStartOfDay(this.userZoneId).toInstant() : TemporalConverter.asOffsetDateTime((Temporal)this.period.getStartDate()).atZoneSameInstant(this.userZoneId).toInstant();
            startDate = Date.from(instant);
            this.setDate(startDate);
        }
        return startDate;
    }

    public CalendarEventOccurrence getOccurrence() {
        return this.occurrence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CalendarEventOccurrenceSocialInformation that = (CalendarEventOccurrenceSocialInformation)((Object)o);
        return Objects.equals(this.userOwnerId, that.userOwnerId) && Objects.equals(this.occurrence, that.occurrence);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userOwnerId, this.occurrence);
    }
}

