/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar.ical;

import java.io.FileWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.Priority;
import org.silverpeas.core.calendar.VisibilityLevel;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.importexport.ExportDescriptor;
import org.silverpeas.core.importexport.Exporter;
import org.silverpeas.core.importexport.ical.ExportableCalendar;
import org.silverpeas.core.importexport.ical.ICalExporterProvider;
import org.silverpeas.core.personalorganizer.model.Attendee;
import org.silverpeas.core.personalorganizer.model.Category;
import org.silverpeas.core.personalorganizer.model.JournalHeader;
import org.silverpeas.core.personalorganizer.model.ParticipationStatus;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.UtilException;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.web.tools.agenda.control.AgendaException;
import org.silverpeas.core.web.tools.agenda.control.AgendaRuntimeException;
import org.silverpeas.core.web.tools.agenda.control.AgendaSessionController;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class ExportIcalManager {
    private SilverpeasCalendar calendar;
    private static final String FIRST_DATE = "1970/01/01";
    private static final String LAST_DATE = "2050/01/01";
    private final String userId;
    private String language = "fr";

    public ExportIcalManager(AgendaSessionController agendaSessionController) {
        this.userId = agendaSessionController.getUserId();
        this.language = agendaSessionController.getLanguage();
        this.setCalendarService();
    }

    public ExportIcalManager(String userId) {
        this.userId = userId;
        this.setCalendarService();
    }

    private String getUserId() {
        return this.userId;
    }

    private String getLanguage() {
        return this.language;
    }

    public String exportIcalAgenda(String startDate, String endDate) throws AgendaException {
        String returnCode = "0";
        String calendarIcsFileName = "agenda" + this.getUserId() + ".ics";
        String filePath = FileRepositoryManager.getTemporaryPath() + calendarIcsFileName;
        Exporter iCalExporter = ICalExporterProvider.getICalExporter();
        try {
            FileWriter fileWriter = new FileWriter(filePath);
            ExportDescriptor descriptor = ExportDescriptor.withWriter((Writer)fileWriter);
            List<CalendarEvent> events = this.getCalendarEvents(startDate, endDate);
            if (events.isEmpty()) {
                returnCode = "2";
            } else {
                iCalExporter.exports(descriptor, () -> ExportableCalendar.with((Collection)events));
            }
        }
        catch (Exception ex) {
            try {
                SilverLogger.getLogger((Object)this).error((Throwable)ex);
                FileFolderManager.deleteFile((String)filePath);
            }
            catch (UtilException ex1) {
                SilverLogger.getLogger((Object)this).error((Throwable)ex1);
            }
            throw new AgendaException(ex);
        }
        return returnCode;
    }

    public String exportIcalAgendaForSynchro() throws AgendaException {
        String calendarIcsFileName = "agenda" + this.getUserId() + ".ics";
        String filePath = null;
        Exporter iCalExporter = ICalExporterProvider.getICalExporter();
        try {
            List<CalendarEvent> events = this.getCalendarEvents(null, null);
            if (!events.isEmpty()) {
                filePath = FileRepositoryManager.getTemporaryPath() + calendarIcsFileName;
                FileWriter fileWriter = new FileWriter(filePath);
                ExportDescriptor descriptor = ExportDescriptor.withWriter((Writer)fileWriter);
                iCalExporter.exports(descriptor, () -> ExportableCalendar.with((Collection)events));
            }
        }
        catch (Exception ex) {
            try {
                SilverLogger.getLogger((Object)this).error((Throwable)ex);
                FileFolderManager.deleteFile(filePath);
            }
            catch (UtilException ex1) {
                SilverLogger.getLogger((Object)this).error((Throwable)ex1);
            }
            throw new AgendaException(ex);
        }
        return filePath;
    }

    private Collection<JournalHeader> getSchedulableCalendar(String startDate, String endDate) throws ParseException {
        return this.calendar.getPeriodSchedulablesForUser(DateUtil.date2SQLDate((String)startDate, (String)this.getLanguage()), DateUtil.date2SQLDate((String)endDate, (String)this.getLanguage()), this.getUserId(), null, new ParticipationStatus("accepted").getString());
    }

    private List<CalendarEvent> getCalendarEvents(String startDate, String endDate) throws ParseException {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        String fromDate = this.at(startDate, this.or(FIRST_DATE));
        String toDate = this.at(endDate, this.or(LAST_DATE));
        Collection<JournalHeader> schedulables = this.getSchedulableCalendar(fromDate, toDate);
        for (JournalHeader schedulable : schedulables) {
            OffsetDateTime startDateTime = OffsetDateTime.ofInstant(schedulable.getStartDate().toInstant(), TimeZone.getDefault().toZoneId());
            OffsetDateTime endDateTime = OffsetDateTime.ofInstant(schedulable.getEndDate().toInstant(), TimeZone.getDefault().toZoneId());
            boolean allDay = StringUtil.isDefined((String)schedulable.getStartHour()) && StringUtil.isDefined((String)schedulable.getEndHour());
            CalendarEvent event = this.getCalendarEvent(startDateTime, endDateTime, allDay);
            event.identifiedBy("event", schedulable.getId()).withTitle(schedulable.getName()).withDescription(schedulable.getDescription());
            event.withVisibilityLevel(VisibilityLevel.valueOf((String)schedulable.getClassification().getString().toUpperCase()));
            event.withPriority(Priority.valueOf((int)schedulable.getPriority().getValue()));
            Collection categories = this.calendar.getJournalCategories(schedulable.getId());
            for (Category category : categories) {
                event.getCategories().add(category.getName());
            }
            Collection attendees = this.calendar.getJournalAttendees(schedulable.getId());
            for (Attendee attendee : attendees) {
                String email;
                UserDetail user = (UserDetail)OrganizationControllerProvider.getOrganisationController().getUserDetail(attendee.getUserId());
                if (user == null || !StringUtil.isDefined((String)(email = user.getEmailAddress()))) continue;
                event.getAttendees().add(email);
            }
            events.add(event);
        }
        return events;
    }

    @Nonnull
    private CalendarEvent getCalendarEvent(OffsetDateTime startDateTime, OffsetDateTime endDateTime, boolean allDay) {
        CalendarEvent event = allDay ? CalendarEvent.on((Period)Period.between((LocalDate)startDateTime.toLocalDate(), (LocalDate)endDateTime.toLocalDate())) : CalendarEvent.on((Period)Period.between((OffsetDateTime)startDateTime, (OffsetDateTime)endDateTime));
        return event;
    }

    private void setCalendarService() {
        if (this.calendar == null) {
            try {
                this.calendar = (SilverpeasCalendar)ServiceProvider.getService(SilverpeasCalendar.class, (Annotation[])new Annotation[0]);
            }
            catch (Exception e) {
                throw new AgendaRuntimeException(e);
            }
        }
    }

    private String at(String aDate, String defaultDate) throws ParseException {
        String at = aDate;
        if (!StringUtil.isDefined((String)aDate)) {
            at = DateUtil.getInputDate((String)defaultDate, (String)this.getLanguage());
        }
        return at;
    }

    private String or(String defaultDate) {
        return defaultDate;
    }
}

