/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.web.authentication.credentials.ChangePasswordFunctionHandler;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class ChangePasswordHandler
extends ChangePasswordFunctionHandler {
    @Override
    public String getFunction() {
        return "ChangePassword";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        String login = request.getParameter("Login");
        String domainId = request.getParameter("DomainId");
        String password = request.getParameter("password");
        String checkId = request.getParameter("checkId");
        try {
            this.assertPasswordHasBeenCorrectlyChecked(checkId, password);
            AuthenticationCredential credential = AuthenticationCredential.newWithAsLogin((String)login).withAsDomainId(domainId);
            this.getAuthenticator().resetPassword(credential, password);
            return "/AuthenticationServlet?Login=" + login + "&Password=" + password + "&DomainId=" + domainId;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("change password error with login {0}", (Object[])new String[]{login}, (Throwable)e);
            return "/Login";
        }
    }
}

