/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.AuthenticationService;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.password.service.PasswordRulesService;
import org.silverpeas.core.security.authentication.password.service.PasswordRulesServiceProvider;
import org.silverpeas.core.security.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.core.web.authentication.credentials.ChangeCredentialFunctionHandler;

public abstract class ChangePasswordFunctionHandler
extends ChangeCredentialFunctionHandler {
    @Inject
    private AuthenticationService authenticator;

    protected UserDetail getRequester(HttpServletRequest request) throws AdminException {
        HttpSession session = request.getSession(true);
        String key = (String)session.getAttribute("svplogin_Key");
        String userId = this.getAdminService().identify(key, session.getId(), false, false);
        return this.getAdminService().getUserDetail(userId);
    }

    protected String performUrlChangePasswordError(HttpServletRequest request, String originalUrl, AuthenticationCredential credential) {
        return this.performUrlOnBadCredentialError(request, originalUrl, AuthenticationUserVerifierFactory.getUserCanTryAgainToLoginVerifier((AuthenticationCredential)credential), "badCredentials");
    }

    protected String performUrlChangePasswordError(HttpServletRequest request, String originalUrl, UserDetail user) {
        return this.performUrlOnBadCredentialError(request, originalUrl, AuthenticationUserVerifierFactory.getUserCanTryAgainToLoginVerifier((User)user), "badCredentials");
    }

    protected void assertPasswordHasBeenCorrectlyChecked(String checkId, String password) throws AuthenticationException {
        PasswordRulesService passwordRuleService = PasswordRulesServiceProvider.getPasswordRulesService();
        if (!passwordRuleService.isChecked(checkId, password)) {
            throw new AuthenticationException("Password wasn't checked against the password rules!", new String[0]);
        }
    }

    protected String changePassword(HttpServletRequest request, User user) throws AuthenticationException {
        String login = user.getLogin();
        String domainId = user.getDomainId();
        String oldPassword = request.getParameter("oldPassword");
        String newPassword = request.getParameter("newPassword");
        String checkId = request.getParameter("checkId");
        this.assertPasswordHasBeenCorrectlyChecked(checkId, newPassword);
        AuthenticationCredential credential = AuthenticationCredential.newWithAsLogin((String)login).withAsPassword(oldPassword).withAsDomainId(domainId);
        this.authenticator.changePassword(credential, newPassword);
        return newPassword;
    }

    protected AuthenticationService getAuthenticator() {
        return this.authenticator;
    }
}

