/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.driver.admin;

import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletType;
import com.sun.portal.portletcontainer.admin.mbeans.PortletAdmin;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryContext;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import com.sun.portal.portletcontainer.driver.admin.PortletAdminData;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.silverpeas.core.web.portlets.portal.PortletAppData;
import org.silverpeas.core.web.portlets.portal.PortletAppDataImpl;
import org.silverpeas.core.web.portlets.portal.PortletWindowData;
import org.silverpeas.kernel.util.StringUtil;

public class PortletAdminDataImpl
implements PortletAdminData,
Serializable {
    private static Logger logger = Logger.getLogger(PortletAdminDataImpl.class.getPackage().getName(), "org.silverpeas.portlets.PCDLogMessages");
    static final long serialVersionUID = 3L;
    private PortletRegistryContext portletRegistryContext;

    @Override
    public void init(PortletRegistryContext portletRegistryContext) throws PortletRegistryException {
        this.portletRegistryContext = portletRegistryContext;
    }

    @Override
    public boolean deploy(String warName, boolean deployToContainer) throws Exception {
        return this.deploy(warName, null, null, deployToContainer);
    }

    @Override
    public boolean deploy(String warName, String rolesFilename, String userInfoFilename, boolean deployToContainer) throws Exception {
        try {
            PortletAdmin portletadmin = new PortletAdmin();
            Properties roleProperties = new Properties();
            if (rolesFilename != null) {
                roleProperties.load(new FileInputStream(rolesFilename));
            }
            Properties userInfoProperties = new Properties();
            if (userInfoFilename != null) {
                userInfoProperties.load(new FileInputStream(userInfoFilename));
            }
            portletadmin.deploy(warName, roleProperties, userInfoProperties, deployToContainer);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                LogRecord logRecord = new LogRecord(Level.SEVERE, "PSPCD_CSPPD0023");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{warName});
                logRecord.setThrown(e);
                logger.log(logRecord);
            }
            throw e;
        }
        return true;
    }

    @Override
    public boolean undeploy(String warName, boolean undeployFromContainer) throws Exception {
        try {
            PortletAdmin portletadmin = new PortletAdmin();
            return portletadmin.undeploy(warName, undeployFromContainer);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                LogRecord logRecord = new LogRecord(Level.SEVERE, "PSPCD_CSPPD0031");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{warName});
                logRecord.setThrown(e);
                logger.log(logRecord);
            }
            throw e;
        }
    }

    @Override
    public List<PortletAppData> getPortlets(String locale) {
        ArrayList<PortletAppData> portlets = new ArrayList<PortletAppData>();
        List<String> portletNames = this.getPortletNames();
        if (portletNames != null) {
            for (String portletName : portletNames) {
                if (portletName == null) continue;
                PortletAppDataImpl portlet = new PortletAppDataImpl(portletName);
                try {
                    String displayName = this.portletRegistryContext.getDisplayName(portletName, locale);
                    if (!StringUtil.isDefined((String)displayName)) {
                        displayName = this.portletRegistryContext.getTitle(portletName, locale);
                    }
                    portlet.setLabel(displayName);
                    String description = this.portletRegistryContext.getDescription(portletName, locale);
                    if (StringUtil.isDefined((String)description)) {
                        portlet.setDescription(description);
                    }
                }
                catch (PortletRegistryException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
                }
                portlets.add(portlet);
            }
        }
        return portlets;
    }

    @Override
    public List<String> getPortletNames() {
        try {
            return this.portletRegistryContext.getAvailablePortlets();
        }
        catch (PortletRegistryException pre) {
            logger.log(Level.SEVERE, "PSPCD_CSPPD0024", pre);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public List<String> getPortletApplicationNames() {
        ArrayList<String> portletApps = new ArrayList<String>();
        try {
            List<EntityID> entityIds = this.portletRegistryContext.getEntityIds();
            if (entityIds != null) {
                for (EntityID entityId : entityIds) {
                    String portletAppName;
                    if (entityId == null || (portletAppName = entityId.getPortletApplicationName()) == null || portletAppName.equals("null") || portletApps.contains(portletAppName)) continue;
                    portletApps.add(portletAppName);
                }
            }
        }
        catch (PortletRegistryException pre) {
            logger.log(Level.SEVERE, "PSPCD_CSPPD0032", pre);
        }
        return portletApps;
    }

    @Override
    public List<String> getPortletDisplayNames(String locale) {
        ArrayList<String> portletApps = new ArrayList<String>();
        try {
            List<String> portletNames = this.getPortletNames();
            for (String portletName : portletNames) {
                String displayName;
                if (portletName == null || !StringUtil.isDefined((String)(displayName = this.portletRegistryContext.getDisplayName(portletName, locale)))) continue;
                portletApps.add(displayName);
            }
        }
        catch (PortletRegistryException e) {
            logger.log(Level.SEVERE, "PSPCD_CSPPD0032", e);
        }
        return portletApps;
    }

    @Override
    public List<String> getPortletWindowNames() {
        try {
            return this.portletRegistryContext.getAllPortletWindows(PortletType.LOCAL);
        }
        catch (PortletRegistryException pre) {
            logger.log(Level.SEVERE, "PSPCD_CSPPD0024", pre);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public boolean createPortletWindow(String portletName, String portletWindowName, String title) throws Exception {
        try {
            this.portletRegistryContext.createPortletWindow(portletName, portletWindowName, title, Locale.getDefault().toString());
        }
        catch (PortletRegistryException pre) {
            if (logger.isLoggable(Level.SEVERE)) {
                LogRecord logRecord = new LogRecord(Level.SEVERE, "PSPCD_CSPPD0025");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{portletName});
                logRecord.setThrown(pre);
                logger.log(logRecord);
            }
            throw pre;
        }
        return true;
    }

    @Override
    public boolean modifyPortletWindow(String portletWindowName, String width, boolean visible, String row) throws Exception {
        try {
            this.portletRegistryContext.setWidth(portletWindowName, width, row);
            boolean exisitingVisibleValue = this.isVisible(portletWindowName);
            if (exisitingVisibleValue != visible) {
                this.portletRegistryContext.showPortletWindow(portletWindowName, visible);
            }
        }
        catch (PortletRegistryException pre) {
            if (logger.isLoggable(Level.SEVERE)) {
                LogRecord logRecord = new LogRecord(Level.SEVERE, "PSPCD_CSPPD0025");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{portletWindowName});
                logRecord.setThrown(pre);
                logger.log(logRecord);
            }
            throw pre;
        }
        return true;
    }

    @Override
    public boolean movePortletWindows(List<PortletWindowData> portletWindows) throws Exception {
        this.portletRegistryContext.movePortletWindows(portletWindows);
        return true;
    }

    @Override
    public boolean isVisible(String portletWindowName) throws Exception {
        return this.portletRegistryContext.isVisible(portletWindowName);
    }

    @Override
    public String getWidth(String portletWindowName) throws Exception {
        return this.portletRegistryContext.getWidth(portletWindowName);
    }
}

