/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;
import org.silverpeas.core.persistence.datasource.repository.PaginationCriterion;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlExecutorProvider;
import org.silverpeas.core.persistence.jdbc.sql.SelectResultRowProcess;
import org.silverpeas.core.persistence.jdbc.sql.SplitExecuteProcess;
import org.silverpeas.core.persistence.jdbc.sql.SplitListProcess;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.kernel.util.StringUtil;

public class JdbcSqlQuery {
    public static final int SPLIT_BATCH = 1500;
    private static final int SPACE_OFFSET_DETECTION = 2;
    private static final int OPEN_PARENTHESIS_OFFSET_DETECTION = 1;
    private static final String NOT_IN_OPERATOR = " NOT IN ";
    private static final String IN_OPERATOR = " IN ";
    private final Configuration configuration = new Configuration();
    private final StringBuilder sqlQuery = new StringBuilder();
    private final Collection<Object> allParameters = new ArrayList<Object>();

    private JdbcSqlQuery() {
    }

    public static boolean isSqlDefined(String sqlValue) {
        return StringUtil.isDefined((String)sqlValue) && !"-1".equals(sqlValue.trim()) && !"unknown".equals(sqlValue.trim());
    }

    public static <E> E unique(List<E> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() == 1) {
            return entities.get(0);
        }
        throw new IllegalArgumentException("wanted to get a unique entity from a list that contains more than one...");
    }

    public static JdbcSqlQuery create(String sqlPart, Object ... paramValue) {
        return new JdbcSqlQuery().addSqlPart(sqlPart, paramValue);
    }

    public static JdbcSqlQuery create(String sqlPart, Collection<?> paramValue) {
        return new JdbcSqlQuery().addSqlPart(sqlPart, paramValue);
    }

    public static JdbcSqlQuery select(String columns) {
        return new JdbcSqlQuery().addSqlPart("SELECT", new Object[0]).addSqlPart(columns, new Object[0]);
    }

    public static JdbcSqlQuery countAll() {
        return new JdbcSqlQuery().addSqlPart("SELECT COUNT(*)", new Object[0]);
    }

    public static JdbcSqlQuery countAllAs(@Nonnull String counterName) {
        return new JdbcSqlQuery().addSqlPart("SELECT COUNT(*) AS", new Object[0]).addSqlPart(counterName, new Object[0]);
    }

    public static JdbcSqlQuery createTable(String tableName) {
        return new JdbcSqlQuery().addSqlPart("CREATE TABLE", new Object[0]).addSqlPart(tableName, new Object[0]).addSqlPart(" (", new Object[0]);
    }

    public static JdbcSqlQuery insertInto(String tableName) {
        return new JdbcSqlQuery().addSqlPart("INSERT INTO", new Object[0]).addSqlPart(tableName, new Object[0]).addSqlPart(" (", new Object[0]);
    }

    public static JdbcSqlQuery update(String tableName) {
        return new JdbcSqlQuery().addSqlPart("UPDATE ", new Object[0]).addSqlPart(tableName, new Object[0]).addSqlPart(" SET", new Object[0]);
    }

    public static JdbcSqlQuery deleteFrom(String tableName) {
        return new JdbcSqlQuery().addSqlPart("DELETE FROM", new Object[0]).addSqlPart(tableName, new Object[0]);
    }

    public static JdbcSqlQuery dropTable(String tableName) {
        return new JdbcSqlQuery().addSqlPart("DROP TABLE", new Object[0]).addSqlPart(tableName, new Object[0]);
    }

    public String getSqlQuery() {
        return this.sqlQuery.toString();
    }

    public Collection<Object> getParameters() {
        return this.allParameters;
    }

    public JdbcSqlQuery configure(Consumer<Configuration> config) {
        config.accept(this.configuration);
        return this;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public JdbcSqlQuery addField(String fieldName, String definition) {
        if (this.sqlQuery.charAt(this.sqlQuery.length() - 2) != ' ' && this.sqlQuery.charAt(this.sqlQuery.length() - 1) != '(') {
            this.sqlQuery.append(", ");
        }
        return this.addSqlPart(fieldName, new Object[0]).addSqlPart(definition, new Object[0]);
    }

    public JdbcSqlQuery union() {
        return this.addSqlPart("UNION ", new Object[0]);
    }

    public JdbcSqlQuery join(String sqlPart) {
        return this.addSqlPart("JOIN " + sqlPart, new Object[0]);
    }

    public JdbcSqlQuery outerJoin(String sqlPart) {
        return this.addSqlPart("LEFT OUTER JOIN " + sqlPart, new Object[0]);
    }

    public JdbcSqlQuery on(String sqlPart, Object ... paramValue) {
        return this.addSqlPart("ON " + sqlPart, Arrays.asList(paramValue));
    }

    public JdbcSqlQuery where(String sqlPart, Object ... paramValue) {
        return this.where(sqlPart, Arrays.asList(paramValue));
    }

    public JdbcSqlQuery where(String sqlPart, Collection<?> paramValues) {
        return this.addSqlPart("WHERE " + sqlPart, paramValues);
    }

    public JdbcSqlQuery from(String ... tableNames) {
        return this.addSqlPart("FROM " + String.join((CharSequence)",", tableNames), new Object[0]);
    }

    public JdbcSqlQuery and(String sqlPart, Object ... paramValue) {
        return this.and(sqlPart, Arrays.asList(paramValue));
    }

    public JdbcSqlQuery and(String sqlPart, Collection<?> paramValues) {
        return this.addSqlPart("AND " + sqlPart, paramValues);
    }

    public JdbcSqlQuery andNotNull(String parameter) {
        return this.addSqlPart("AND " + parameter + " IS NOT NULL", new Object[0]);
    }

    public JdbcSqlQuery andNull(String parameter) {
        return this.addSqlPart("AND " + parameter + " IS NULL", new Object[0]);
    }

    public JdbcSqlQuery or(String sqlPart, Object ... paramValue) {
        return this.or(sqlPart, Arrays.asList(paramValue));
    }

    public JdbcSqlQuery or(String sqlPart, Collection<?> paramValues) {
        return this.addSqlPart("OR " + sqlPart, paramValues);
    }

    public JdbcSqlQuery orNotNull(String parameter) {
        return this.addSqlPart("OR " + parameter + " IS NOT NULL", new Object[0]);
    }

    public JdbcSqlQuery orNull(String parameter) {
        return this.addSqlPart("OR " + parameter + " IS NULL", new Object[0]);
    }

    public JdbcSqlQuery orderBy(String ... fields) {
        if (fields != null && fields.length > 0) {
            return this.addSqlPart("ORDER BY " + String.join((CharSequence)",", fields), new Object[0]);
        }
        return this;
    }

    public JdbcSqlQuery groupBy(String ... fields) {
        if (fields != null && fields.length > 0) {
            return this.addSqlPart("GROUP BY " + String.join((CharSequence)",", fields), new Object[0]);
        }
        return this;
    }

    public JdbcSqlQuery limit(int count) {
        this.configuration.withResultLimit(count);
        return this;
    }

    public JdbcSqlQuery offset(int offset) {
        this.configuration.withOffset(offset);
        return this;
    }

    public JdbcSqlQuery withPagination(PaginationCriterion pagination) {
        if (pagination != null && pagination.isDefined()) {
            this.offset((pagination.getPageNumber() - 1) * pagination.getItemCount());
            this.limit(pagination.getItemCount());
            if (!pagination.isOriginalSizeNeeded()) {
                this.configuration.ignoreRealOriginalSize();
            }
        }
        return this;
    }

    public JdbcSqlQuery addSqlPart(String sqlPart, Object ... paramValue) {
        return this.addSqlPart(sqlPart, Arrays.asList(paramValue));
    }

    private JdbcSqlQuery addSqlPart(String sqlPart, Collection<?> paramValues) {
        char lastChar;
        this.allParameters.addAll(paramValues);
        if (this.sqlQuery.length() > 0 && (lastChar = this.sqlQuery.charAt(this.sqlQuery.length() - 1)) != ' ' && lastChar != '(') {
            this.sqlQuery.append(" ");
        }
        this.sqlQuery.append(sqlPart.trim().replaceAll(" +", " "));
        return this;
    }

    public JdbcSqlQuery in(Collection<?> parameters) {
        if (CollectionUtil.isEmpty(parameters)) {
            throw new IllegalArgumentException("cannot apply in clause because no value to set ! query=" + String.valueOf(this.sqlQuery));
        }
        if (parameters.size() == 1) {
            this.addSqlPart(" = ?", parameters);
        } else {
            this.sqlQuery.append(IN_OPERATOR);
            this.addListOfParameters(parameters, true);
        }
        return this;
    }

    public JdbcSqlQuery in(Object ... parameters) {
        if (ArrayUtils.isEmpty((Object[])parameters)) {
            throw new IllegalArgumentException("cannot apply in clause because no value to set ! query=" + String.valueOf(this.sqlQuery));
        }
        if (parameters.length == 1) {
            this.addSqlPart("= ?", parameters);
        } else {
            this.sqlQuery.append(IN_OPERATOR);
            this.addListOfParameters(Arrays.asList(parameters), true);
        }
        return this;
    }

    public JdbcSqlQuery notIn(Collection<?> parameters) {
        if (CollectionUtil.isEmpty(parameters)) {
            throw new IllegalArgumentException("cannot apply not in clause because no value to set ! query=" + String.valueOf(this.sqlQuery));
        }
        if (parameters.size() == 1) {
            this.addSqlPart("<> ?", parameters);
        } else {
            this.sqlQuery.append(NOT_IN_OPERATOR);
            this.addListOfParameters(parameters, true);
        }
        return this;
    }

    public JdbcSqlQuery notIn(Object ... parameters) {
        if (ArrayUtils.isEmpty((Object[])parameters)) {
            throw new IllegalArgumentException("cannot apply not in clause because no value to set ! query=" + String.valueOf(this.sqlQuery));
        }
        if (parameters.length == 1) {
            this.addSqlPart("<> ?", parameters);
        } else {
            this.sqlQuery.append(NOT_IN_OPERATOR);
            this.addListOfParameters(Arrays.asList(parameters), true);
        }
        return this;
    }

    private void valuesForInsert() {
        if (this.isNotSqlQueryCompleted()) {
            this.sqlQuery.append(") values");
            this.addListOfParameters(this.allParameters, false);
        }
    }

    private void finalizeTableCreation() {
        if (this.isNotSqlQueryCompleted()) {
            this.sqlQuery.append(")");
        }
    }

    private boolean isNotSqlQueryCompleted() {
        char lastChar = this.sqlQuery.charAt(this.sqlQuery.length() - 1);
        int openParenthesisCount = 0;
        int closeParenthesisCount = 0;
        for (int i = 0; i < this.sqlQuery.length(); ++i) {
            char currentChar = this.sqlQuery.charAt(i);
            if (currentChar == '(') {
                ++openParenthesisCount;
                continue;
            }
            if (currentChar != ')') continue;
            ++closeParenthesisCount;
        }
        return lastChar != ';' && openParenthesisCount != closeParenthesisCount;
    }

    private void addListOfParameters(Collection<?> parameters, boolean addToParameters) {
        if (parameters == null) {
            return;
        }
        int threshold = 1000;
        int end = -1;
        String negation = "";
        if (parameters.size() > 1000) {
            end = this.sqlQuery.lastIndexOf(NOT_IN_OPERATOR);
            negation = " NOT ";
            if (end + NOT_IN_OPERATOR.length() < this.sqlQuery.length()) {
                end = this.sqlQuery.lastIndexOf(IN_OPERATOR);
                negation = "";
                if (end + IN_OPERATOR.length() < this.sqlQuery.length()) {
                    end = -1;
                }
            }
        }
        if (end > -1) {
            int from = end - 1;
            while (this.sqlQuery.charAt(from) != ' ') {
                --from;
            }
            String currentSqlPart = this.sqlQuery.substring(from + 1, end);
            this.sqlQuery.delete(from + 1, this.sqlQuery.length()).append(negation).append("(");
            ArrayList listOfParameters = new ArrayList(parameters);
            for (int i = 0; i < listOfParameters.size(); i += 1000) {
                String params = this.sublistOfParameters(i, i + 1000, listOfParameters);
                this.sqlQuery.append(currentSqlPart).append(" IN (").append(params).append(") OR ");
            }
            int lengthOfORLink = 4;
            this.sqlQuery.replace(this.sqlQuery.length() - 4, this.sqlQuery.length(), ")");
        } else {
            String params = parameters.stream().map(p -> "?").collect(Collectors.joining(","));
            this.sqlQuery.append(" (").append(params).append(")");
        }
        if (addToParameters) {
            this.allParameters.addAll(parameters);
        }
    }

    private String sublistOfParameters(int fromIndex, int toIndex, List<?> listOfParameters) {
        int limit = toIndex;
        if (limit > listOfParameters.size()) {
            limit = listOfParameters.size();
        }
        return listOfParameters.subList(fromIndex, limit).stream().map(p -> "?").collect(Collectors.joining(","));
    }

    public JdbcSqlQuery withInsertParam(String paramName, Object paramValue) {
        return this.withSaveParam(paramName, paramValue, true);
    }

    public JdbcSqlQuery withUpdateParam(String paramName, Object paramValue) {
        return this.withSaveParam(paramName, paramValue, false);
    }

    public JdbcSqlQuery withSaveParam(String paramName, Object paramValue, boolean isInsert) {
        if (!this.allParameters.isEmpty()) {
            this.sqlQuery.append(", ");
        } else if (!isInsert) {
            this.sqlQuery.append(" ");
        }
        this.sqlQuery.append(paramName.trim());
        if (!isInsert) {
            this.sqlQuery.append(" = ?");
        }
        this.allParameters.add(paramValue);
        return this;
    }

    public static <I, T> Map<I, List<T>> executeBySplittingOn(Collection<I> discriminantData, SplitExecuteProcess<I, T> process) throws SQLException {
        HashMap result = new HashMap(discriminantData.size());
        for (Collection<I> d : CollectionUtil.split(discriminantData, 1500)) {
            process.execute(d, result);
        }
        return result;
    }

    public static <I, T> Stream<T> streamBySplittingOn(Collection<I> discriminantData, SplitListProcess<I, List<T>> process) throws SQLException {
        Stream result = Stream.empty();
        for (Collection<I> d : CollectionUtil.split(discriminantData, 1500)) {
            result = Stream.concat(result, process.execute(d).stream());
        }
        return result;
    }

    public static <I, T> Stream<T> streamBySplittingOn(Collection<I> discriminantData, SplitListProcess<I, List<T>> process, Function<T, I> idGetter) throws SQLException {
        Map<I, Object> indexedResult = JdbcSqlQuery.streamBySplittingOn(discriminantData, process).collect(Collectors.toMap(idGetter, r -> r));
        return discriminantData.stream().map(indexedResult::get).filter(Objects::nonNull);
    }

    public <R> ListSlice<R> execute(SelectResultRowProcess<R> process) throws SQLException {
        return this.executeWith(null, process);
    }

    public <R> ListSlice<R> executeWith(Connection connection, SelectResultRowProcess<R> process) throws SQLException {
        if (connection == null) {
            return JdbcSqlExecutorProvider.getJdbcSqlExecutor().select(this, process);
        }
        return JdbcSqlExecutorProvider.getJdbcSqlExecutor().select(connection, this, process);
    }

    public <R> R executeUnique(SelectResultRowProcess<R> process) throws SQLException {
        return this.executeUniqueWith(null, process);
    }

    public <R> R executeUniqueWith(Connection connection, SelectResultRowProcess<R> process) throws SQLException {
        return JdbcSqlQuery.unique(this.executeWith(connection, process));
    }

    void finalizeBeforeExecution() {
        String computedSqlQuery = this.getSqlQuery();
        if (computedSqlQuery.startsWith("INSERT INTO ")) {
            this.valuesForInsert();
        } else if (computedSqlQuery.startsWith("CREATE TABLE ")) {
            this.finalizeTableCreation();
        }
    }

    public long execute() throws SQLException {
        return this.executeWith(null);
    }

    public long executeWith(Connection connection) throws SQLException {
        int lengthOfStartStatement = 13;
        String builtSqlQuery = this.getSqlQuery().trim();
        if ("SELECT COUNT(".equalsIgnoreCase(builtSqlQuery.substring(0, 13))) {
            if (connection == null) {
                return JdbcSqlExecutorProvider.getJdbcSqlExecutor().selectCount(this);
            }
            return JdbcSqlExecutorProvider.getJdbcSqlExecutor().selectCount(connection, this);
        }
        if (connection == null) {
            return JdbcSqlExecutorProvider.getJdbcSqlExecutor().executeModify(Collections.singletonList(this));
        }
        return JdbcSqlExecutorProvider.getJdbcSqlExecutor().executeModify(connection, Collections.singletonList(this));
    }

    public static class Configuration {
        private int limit = 0;
        private int offset = 0;
        private boolean needRealOriginalSize = true;

        int getResultLimit() {
            return this.limit;
        }

        int getOffset() {
            return this.offset;
        }

        boolean isFirstResultScrolled() {
            return this.offset > 0;
        }

        boolean isResultCountLimited() {
            return this.limit > 0;
        }

        public boolean isNeedRealOriginalSize() {
            return this.needRealOriginalSize;
        }

        public Configuration withResultLimit(int limit) {
            if (limit < 0) {
                throw new IllegalArgumentException("Invalid limit: expected positive value");
            }
            this.limit = limit;
            return this;
        }

        public Configuration withOffset(int offset) {
            if (offset < 0) {
                throw new IllegalArgumentException("Invalid offset: expected positive value");
            }
            this.offset = offset;
            return this;
        }

        public Configuration ignoreRealOriginalSize() {
            this.needRealOriginalSize = false;
            return this;
        }
    }
}

