/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.model.jpa;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.persistence.datasource.model.Entity;
import org.silverpeas.core.persistence.datasource.model.EntityIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.AbstractJpaEntity;
import org.silverpeas.core.persistence.datasource.model.jpa.JpaPersistOperation;
import org.silverpeas.core.persistence.datasource.model.jpa.JpaUpdateOperation;
import org.silverpeas.core.util.ArgumentAssertion;
import org.silverpeas.kernel.util.StringUtil;

@MappedSuperclass
public abstract class SilverpeasJpaEntity<E extends Entity<E, I>, I extends EntityIdentifier>
extends AbstractJpaEntity<E, I>
implements Entity<E, I> {
    private static final long serialVersionUID = 5862667014447543891L;
    @Transient
    private User creator;
    @Transient
    private User lastUpdater;
    @Column(name="createdBy", nullable=false, insertable=true, updatable=false, length=40)
    private String creatorId;
    @Column(name="createDate", nullable=false, insertable=true, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate = null;
    @Column(name="lastUpdatedBy", nullable=false, length=40)
    private String lastUpdaterId;
    @Column(name="lastUpdateDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUpdateDate = null;
    @Version
    @Column(name="version", nullable=false)
    private Long version = 0L;

    @Override
    public boolean hasBeenModified() {
        return this.isPersisted() && this.getVersion() > 0L;
    }

    @Override
    public final User getCreator() {
        if (StringUtil.isDefined((String)this.getCreatorId())) {
            if (this.creator == null || !this.getCreatorId().equals(this.creator.getId())) {
                this.creator = User.getById(this.getCreatorId());
            }
        } else {
            this.creator = null;
        }
        return this.creator;
    }

    @Override
    public E createdBy(User creator) {
        return this.createdBy(creator, new Date());
    }

    @Override
    public E createdBy(User creator, Date creationDate) {
        ArgumentAssertion.assertNotNull(creator, "creator must exist");
        ArgumentAssertion.assertNotNull(creationDate, "create date must exist");
        if (!this.isPersisted() && creator != null && creationDate != null) {
            OperationContext.getFromCache().getPersistenceOperation(JpaPersistOperation.class).setManuallyTechnicalDataFor(this, creator, creationDate);
        } else {
            this.setCreationDate(creationDate);
            this.creator = creator;
            this.creatorId = creator != null ? creator.getId() : null;
        }
        return (E)this;
    }

    @Override
    public final User getLastUpdater() {
        if (this.lastUpdater == null || this.getLastUpdaterId() != null && !this.getLastUpdaterId().equals(this.lastUpdater.getId())) {
            this.lastUpdater = User.getById(this.getLastUpdaterId());
        }
        return this.lastUpdater;
    }

    @Override
    public E updatedBy(User updater) {
        return this.updatedBy(updater, new Date());
    }

    @Override
    public E updatedBy(User updater, Date updateDate) {
        ArgumentAssertion.assertNotNull(updater, "updater must exist");
        ArgumentAssertion.assertNotNull(updateDate, "update date must exist");
        if (this.isPersisted()) {
            OperationContext.getFromCache().getPersistenceOperation(JpaUpdateOperation.class).setManuallyTechnicalDataFor(this, updater, updateDate);
        } else {
            this.setLastUpdateDate(updateDate);
            this.lastUpdater = updater;
            this.lastUpdaterId = updater.getId();
        }
        return (E)this;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    public E createdBy(String creatorId) {
        return this.createdBy(User.getById(creatorId), new Date());
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    protected SilverpeasJpaEntity<E, I> setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    protected SilverpeasJpaEntity<E, I> setCreator(User creator) {
        this.creator = creator;
        this.creatorId = creator == null ? null : creator.getId();
        return this;
    }

    @Override
    public Date getLastUpdateDate() {
        return this.lastUpdateDate == null ? this.creationDate : this.lastUpdateDate;
    }

    protected SilverpeasJpaEntity<E, I> setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    protected SilverpeasJpaEntity<E, I> setLastUpdater(User updater) {
        this.lastUpdater = updater;
        this.lastUpdaterId = updater == null ? null : updater.getId();
        return this;
    }

    @Override
    public String getLastUpdaterId() {
        return this.lastUpdaterId;
    }

    public E lastUpdatedBy(String lastUpdaterId) {
        return this.updatedBy(User.getById(lastUpdaterId), new Date());
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    protected E setVersion(Long version) {
        this.version = version;
        return (E)this;
    }

    @Override
    public final void markAsModified() {
        if (this.getLastUpdateDate() != null) {
            this.setLastUpdateDate(new Date(this.getLastUpdateDate().getTime() + 1L));
        }
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hash = new HashCodeBuilder();
        hash.append(this.getId() != null ? this.getId() : Integer.valueOf(super.hashCode()));
        return hash.toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (this.getId() != null && other.getId() != null) {
            EqualsBuilder matcher = new EqualsBuilder();
            matcher.append((Object)this.getId(), (Object)other.getId());
            return matcher.isEquals();
        }
        return false;
    }

    @Override
    protected void performBeforePersist() {
        OperationContext.getFromCache().getPersistenceOperation(JpaPersistOperation.class).applyTechnicalDataTo(this);
        ArgumentAssertion.assertDefined(this.getCreatorId(), "createdBy attribute of entity " + this.getClass().getName() + " must exists on insert");
        ArgumentAssertion.assertDefined(this.getLastUpdaterId(), "lastUpdatedBy attribute of entity " + this.getClass().getName() + " must exists on insert");
        this.clearSystemData();
    }

    @Override
    protected void performBeforeUpdate() {
        OperationContext.getFromCache().getPersistenceOperation(JpaUpdateOperation.class).applyTechnicalDataTo(this);
        ArgumentAssertion.assertDefined(this.getLastUpdaterId(), "lastUpdatedBy attribute of entity " + this.getClass().getName() + " must exists on update");
        this.clearSystemData();
    }

    @Override
    protected void performBeforeRemove() {
    }

    private void clearSystemData() {
        OperationContext.getFromCache().getPersistenceOperation(JpaPersistOperation.class).clear(this);
        OperationContext.getFromCache().getPersistenceOperation(JpaUpdateOperation.class).clear(this);
    }
}

