/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.sse;

import java.io.IOException;
import javax.websocket.Session;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.sse.AbstractServerEventContext;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContextManager;
import org.silverpeas.core.notification.sse.SseLogger;
import org.silverpeas.core.util.JSONCodec;

public class SilverpeasWebSocketContext
extends AbstractServerEventContext<Session> {
    private final String requestURI = ((Session)this.getWrappedInstance()).getRequestURI().toString().replaceFirst("[?].*$", "");
    private boolean closed = false;

    SilverpeasWebSocketContext(SilverpeasServerEventContextManager manager, Session wrappedInstance, String sessionId, User user) {
        super(manager, wrappedInstance, sessionId, user);
    }

    public static SilverpeasWebSocketContext wrap(Session session, String userSessionId, User user) {
        if (session instanceof SilverpeasWebSocketContext) {
            return (SilverpeasWebSocketContext)session;
        }
        return new SilverpeasWebSocketContext(SilverpeasServerEventContextManager.get(), session, userSessionId, user);
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    @Override
    public boolean isSendPossible() {
        return this.safeRead(() -> !this.closed && ((Session)this.getWrappedInstance()).isOpen());
    }

    @Override
    public void close() {
        this.safeWrite(() -> {
            this.closed = true;
            try {
                if (((Session)this.getWrappedInstance()).isOpen()) {
                    ((Session)this.getWrappedInstance()).close();
                }
            }
            catch (IOException e) {
                SseLogger.get().error((Throwable)e);
            }
        });
        this.getManager().unregister(this);
    }

    @Override
    public void performEventSend(String name, long id, String data) throws IOException {
        ((Session)this.getWrappedInstance()).getAsyncRemote().sendObject((Object)JSONCodec.encodeObject(o -> o.put("name", name).put("id", id).put("data", data)));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

