/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.sse;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.sse.ServerEventDispatcherTask;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContext;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContextManager;
import org.silverpeas.core.notification.sse.SseLogger;

abstract class AbstractServerEventContext<W>
implements SilverpeasServerEventContext {
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final SilverpeasServerEventContextManager manager;
    private final W wrappedInstance;
    private final String sessionId;
    private final User user;
    private Long lastServerEventId;

    AbstractServerEventContext(SilverpeasServerEventContextManager manager, W wrappedInstance, String sessionId, User user) {
        this.manager = manager;
        this.wrappedInstance = wrappedInstance;
        this.sessionId = sessionId;
        this.user = user;
    }

    <T> T safeRead(Supplier<T> process) {
        this.lock.readLock().lock();
        try {
            T t = process.get();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void safeWrite(Runnable process) {
        this.lock.writeLock().lock();
        try {
            process.run();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public Long getLastServerEventId() {
        return this.safeRead(() -> this.lastServerEventId);
    }

    @Override
    public void setLastServerEventId(Long lastServerEventId) {
        this.safeWrite(() -> {
            this.lastServerEventId = lastServerEventId;
        });
    }

    protected W getWrappedInstance() {
        return this.wrappedInstance;
    }

    protected SilverpeasServerEventContextManager getManager() {
        return this.manager;
    }

    @Override
    public boolean sendEvent(String name, long id, String data) throws IOException {
        if (!this.isSendPossible()) {
            SseLogger.get().debug(() -> MessageFormat.format("No more usable {0}", this));
            ServerEventDispatcherTask.unregisterContext(this);
            return false;
        }
        this.performEventSend(name, id, data);
        return true;
    }

    protected abstract void performEventSend(String var1, long var2, String var4) throws IOException;

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        tsb.append("on", (Object)this.getRequestURI());
        tsb.append("sessionId", (Object)this.getSessionId());
        tsb.append("userId", (Object)this.getUser().getId());
        if (this.getLastServerEventId() != null) {
            tsb.append("lastServerEventId", (Object)this.getLastServerEventId());
        }
        return tsb.toString();
    }
}

