/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

public enum Priority {
    NORMAL,
    HIGH;

    private static final int HIGH_ICAL_LEVEL = 1;
    private static final int HIGH_ICAL_LEVEL_THRESHOLD = 4;

    public static Priority valueOf(int ordinal) {
        if (ordinal == NORMAL.ordinal()) {
            return NORMAL;
        }
        if (ordinal >= HIGH.ordinal()) {
            return HIGH;
        }
        throw new IllegalArgumentException("The specified ordinal, " + ordinal + ", isn't supported");
    }

    public static Priority fromICalLevel(int iCalLevel) {
        return 0 < iCalLevel && iCalLevel <= 4 ? HIGH : NORMAL;
    }

    public int getICalLevel() {
        return this == HIGH ? 1 : 0;
    }
}

