/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.backgroundprocess;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.backgroundprocess.AbstractBackgroundProcessRequest;
import org.silverpeas.core.backgroundprocess.BackgroundProcessLogger;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.thread.task.RequestTaskManager;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;

@Technical
@Bean
public class BackgroundProcessTask
extends AbstractRequestTask<AbstractRequestTask.ProcessContext> {
    static final Map<String, RequestContext> synchronizedContexts = Collections.synchronizedMap(new LinkedHashMap(2000));

    BackgroundProcessTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateContextWith(AbstractBackgroundProcessRequest request) {
        Map<String, RequestContext> map = synchronizedContexts;
        synchronized (map) {
            RequestContext context = synchronizedContexts.get(request.getUniqueId());
            if (context == null || context.isRemovable()) {
                RequestContext newRequestContext = new RequestContext(request);
                synchronizedContexts.put(request.getUniqueId(), newRequestContext);
                BackgroundProcessTask.getLogger().debug(() -> MessageFormat.format("pushing a new process {0}", newRequestContext));
                RequestTaskManager.get().push(BackgroundProcessTask.class, request);
            } else {
                BackgroundProcessTask.getLogger().debug(() -> MessageFormat.format("ignoring a process because it is yet registered and still living {0}", context));
            }
        }
    }

    private static SilverLogger getLogger() {
        return BackgroundProcessLogger.get();
    }

    public static void push(AbstractBackgroundProcessRequest request) {
        BackgroundProcessTask.updateContextWith(request);
    }

    static void purgeContexts() {
        synchronizedContexts.entrySet().removeIf(entry -> ((RequestContext)entry.getValue()).isRemovable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRequest(AbstractRequestTask.Request<AbstractRequestTask.ProcessContext> request) throws SilverpeasException {
        AbstractBackgroundProcessRequest currentRequest = (AbstractBackgroundProcessRequest)request;
        Map<String, RequestContext> map = synchronizedContexts;
        synchronized (map) {
            RequestContext context = synchronizedContexts.get(currentRequest.getUniqueId());
            BackgroundProcessTask.getLogger().debug(() -> MessageFormat.format("process will be executed {0}", context));
            context.requestWillBeExecuted();
        }
        super.processRequest(request);
    }

    private static class RequestContext {
        private final AbstractBackgroundProcessRequest request;
        private long lastProcessing = 0L;

        RequestContext(AbstractBackgroundProcessRequest request) {
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestWillBeExecuted() {
            Map<String, RequestContext> map = synchronizedContexts;
            synchronized (map) {
                this.lastProcessing = System.currentTimeMillis();
                if (this.isRemovable()) {
                    BackgroundProcessTask.getLogger().debug(() -> MessageFormat.format("removing {0} from context", this));
                    synchronizedContexts.remove(this.request.getUniqueId());
                }
            }
        }

        boolean isRemovable() {
            return this.lastProcessing > 0L && this.request.getLockDuration().isNoMoreValid(this.lastProcessing);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Map<String, RequestContext> map = synchronizedContexts;
            synchronized (map) {
                return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("uniqueId", (Object)this.request.getUniqueId()).append("lock duration", (Object)this.request.getLockDuration()).append("last processing time", this.lastProcessing).build();
            }
        }
    }

    public static enum LOCK_DURATION {
        NO_TIME(0L),
        TEN_SECONDS(10000L),
        AN_HOUR(3600000L),
        AN_HALF_DAY(43200000L),
        A_DAY(86400000L);

        private final long duration;

        private LOCK_DURATION(long duration) {
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration;
        }

        public boolean isNoMoreValid(long reference) {
            long now = System.currentTimeMillis();
            return now - reference >= this.duration;
        }
    }
}

