/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.Datum;

class DateAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 7;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    DateAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.DATE, oracleStatement, 7, bl);
        this.init(oracleStatement, 12, 12, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    DateAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        super(Representation.DATE, oracleStatement, 7, false);
        this.init(oracleStatement, 12, 12, s2, false);
        this.initForDescribe(12, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = null;
        if (this.isNull(n2)) {
            return null;
        }
        if (this.externalType == 0) {
            string = this.statement.connection.mapDateToTimestamp ? this.getTimestamp(n2).toString() : this.getDate(n2).toString();
        } else {
            this.getBytesInternal(n2, this.tmpBytes);
            int n3 = this.oracleYear(this.tmpBytes);
            int n4 = 0;
            n4 = this.tmpBytes[4] - 1;
            string = this.toText(n3, this.tmpBytes[2], this.tmpBytes[3], n4, this.tmpBytes[5] - 1, this.tmpBytes[6] - 1, -1, n4 < 12, null);
        }
        return string;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        if (this.externalType == 0) {
            if (this.statement.connection.mapDateToTimestamp) {
                return this.getTimestamp(n2);
            }
            return this.getDate(n2);
        }
        switch (this.externalType) {
            case 91: {
                return this.getDate(n2);
            }
            case 92: {
                return this.getTime(n2);
            }
            case 93: {
                return this.getTimestamp(n2);
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getDATE(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }
}

