/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSidewaysQuery;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.MultiFacets;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.MultiCollectorManager;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.ThreadInterruptedException;

public class DrillSideways {
    protected final IndexSearcher searcher;
    protected final TaxonomyReader taxoReader;
    protected final SortedSetDocValuesReaderState state;
    protected final FacetsConfig config;
    private final ExecutorService executor;

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader) {
        this(searcher, config, taxoReader, null);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, SortedSetDocValuesReaderState state) {
        this(searcher, config, null, state);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader, SortedSetDocValuesReaderState state) {
        this(searcher, config, taxoReader, state, null);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader, SortedSetDocValuesReaderState state, ExecutorService executor) {
        this.searcher = searcher;
        this.config = config;
        this.taxoReader = taxoReader;
        this.state = state;
        this.executor = executor;
    }

    protected Facets buildFacetsResult(FacetsCollector drillDowns, FacetsCollector[] drillSideways, String[] drillSidewaysDims) throws IOException {
        Facets drillDownFacets;
        HashMap<String, Facets> drillSidewaysFacets = new HashMap<String, Facets>();
        if (this.taxoReader != null) {
            drillDownFacets = new FastTaxonomyFacetCounts(this.taxoReader, this.config, drillDowns);
            if (drillSideways != null) {
                for (int i = 0; i < drillSideways.length; ++i) {
                    drillSidewaysFacets.put(drillSidewaysDims[i], new FastTaxonomyFacetCounts(this.taxoReader, this.config, drillSideways[i]));
                }
            }
        } else {
            drillDownFacets = new SortedSetDocValuesFacetCounts(this.state, drillDowns);
            if (drillSideways != null) {
                for (int i = 0; i < drillSideways.length; ++i) {
                    drillSidewaysFacets.put(drillSidewaysDims[i], new SortedSetDocValuesFacetCounts(this.state, drillSideways[i]));
                }
            }
        }
        if (drillSidewaysFacets.isEmpty()) {
            return drillDownFacets;
        }
        return new MultiFacets(drillSidewaysFacets, drillDownFacets);
    }

    public DrillSidewaysResult search(DrillDownQuery query, Collector hitCollector) throws IOException {
        Map<String, Integer> drillDownDims = query.getDims();
        FacetsCollector drillDownCollector = new FacetsCollector();
        if (drillDownDims.isEmpty()) {
            this.searcher.search((Query)query, MultiCollector.wrap((Collector[])new Collector[]{hitCollector, drillDownCollector}));
            return new DrillSidewaysResult(this.buildFacetsResult(drillDownCollector, null, null), null);
        }
        Query baseQuery = query.getBaseQuery();
        if (baseQuery == null) {
            baseQuery = new MatchAllDocsQuery();
        }
        Query[] drillDownQueries = query.getDrillDownQueries();
        Collector[] drillSidewaysCollectors = new FacetsCollector[drillDownDims.size()];
        for (int i = 0; i < drillSidewaysCollectors.length; ++i) {
            drillSidewaysCollectors[i] = new FacetsCollector();
        }
        DrillSidewaysQuery dsq = new DrillSidewaysQuery(baseQuery, drillDownCollector, drillSidewaysCollectors, drillDownQueries, this.scoreSubDocsAtOnce());
        if (!hitCollector.needsScores()) {
            hitCollector = new FilterCollector((Collector)hitCollector){

                public boolean needsScores() {
                    return true;
                }
            };
        }
        this.searcher.search((Query)dsq, hitCollector);
        return new DrillSidewaysResult(this.buildFacetsResult(drillDownCollector, (FacetsCollector[])drillSidewaysCollectors, drillDownDims.keySet().toArray(new String[drillDownDims.size()])), null);
    }

    public DrillSidewaysResult search(DrillDownQuery query, Query filter, final FieldDoc after, final int topN, final Sort sort, final boolean doDocScores, final boolean doMaxScore) throws IOException {
        if (filter != null) {
            query = new DrillDownQuery(this.config, filter, query);
        }
        if (sort != null) {
            int limit = this.searcher.getIndexReader().maxDoc();
            if (limit == 0) {
                limit = 1;
            }
            final int fTopN = Math.min(topN, limit);
            if (this.executor != null) {
                CollectorManager<TopFieldCollector, TopFieldDocs> collectorManager = new CollectorManager<TopFieldCollector, TopFieldDocs>(){

                    public TopFieldCollector newCollector() throws IOException {
                        return TopFieldCollector.create((Sort)sort, (int)fTopN, (FieldDoc)after, (boolean)true, (boolean)doDocScores, (boolean)doMaxScore);
                    }

                    public TopFieldDocs reduce(Collection<TopFieldCollector> collectors) throws IOException {
                        TopFieldDocs[] topFieldDocs = new TopFieldDocs[collectors.size()];
                        int pos = 0;
                        for (TopFieldCollector collector : collectors) {
                            topFieldDocs[pos++] = collector.topDocs();
                        }
                        return TopDocs.merge((Sort)sort, (int)topN, (TopFieldDocs[])topFieldDocs);
                    }
                };
                ConcurrentDrillSidewaysResult<TopFieldDocs> r = this.search(query, collectorManager);
                return new DrillSidewaysResult(r.facets, (TopDocs)r.collectorResult);
            }
            TopFieldCollector hitCollector = TopFieldCollector.create((Sort)sort, (int)fTopN, (FieldDoc)after, (boolean)true, (boolean)doDocScores, (boolean)doMaxScore);
            DrillSidewaysResult r = this.search(query, (Collector)hitCollector);
            return new DrillSidewaysResult(r.facets, (TopDocs)hitCollector.topDocs());
        }
        return this.search((ScoreDoc)after, query, topN);
    }

    public DrillSidewaysResult search(DrillDownQuery query, int topN) throws IOException {
        return this.search(null, query, topN);
    }

    public DrillSidewaysResult search(final ScoreDoc after, DrillDownQuery query, final int topN) throws IOException {
        int limit = this.searcher.getIndexReader().maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        final int fTopN = Math.min(topN, limit);
        if (this.executor != null) {
            CollectorManager<TopScoreDocCollector, TopDocs> collectorManager = new CollectorManager<TopScoreDocCollector, TopDocs>(){

                public TopScoreDocCollector newCollector() throws IOException {
                    return TopScoreDocCollector.create((int)fTopN, (ScoreDoc)after);
                }

                public TopDocs reduce(Collection<TopScoreDocCollector> collectors) throws IOException {
                    TopDocs[] topDocs = new TopDocs[collectors.size()];
                    int pos = 0;
                    for (TopScoreDocCollector collector : collectors) {
                        topDocs[pos++] = collector.topDocs();
                    }
                    return TopDocs.merge((int)topN, (TopDocs[])topDocs);
                }
            };
            ConcurrentDrillSidewaysResult<TopDocs> r = this.search(query, collectorManager);
            return new DrillSidewaysResult(r.facets, (TopDocs)r.collectorResult);
        }
        TopScoreDocCollector hitCollector = TopScoreDocCollector.create((int)topN, (ScoreDoc)after);
        DrillSidewaysResult r = this.search(query, (Collector)hitCollector);
        return new DrillSidewaysResult(r.facets, hitCollector.topDocs());
    }

    protected boolean scoreSubDocsAtOnce() {
        return false;
    }

    private DrillDownQuery getDrillDownQuery(DrillDownQuery query, Query[] queries, String excludedDimension) {
        DrillDownQuery ddl = new DrillDownQuery(this.config, query.getBaseQuery());
        query.getDims().forEach((dim, pos) -> {
            if (!dim.equals(excludedDimension)) {
                ddl.add((String)dim, queries[pos]);
            }
        });
        return ddl.getDims().size() == queries.length ? null : ddl;
    }

    public <R> ConcurrentDrillSidewaysResult<R> search(DrillDownQuery query, CollectorManager<?, R> hitCollectorManager) throws IOException {
        Object collectorResult;
        FacetsCollector mainFacetsCollector;
        Map<String, Integer> drillDownDims = query.getDims();
        ArrayList<CallableCollector> callableCollectors = new ArrayList<CallableCollector>(drillDownDims.size() + 1);
        callableCollectors.add(new CallableCollector(-1, this.searcher, query, (CollectorManager)new MultiCollectorManager(new CollectorManager[]{new FacetsCollectorManager(), hitCollectorManager})));
        int i = 0;
        Query[] filters = query.getDrillDownQueries();
        for (String dim : drillDownDims.keySet()) {
            callableCollectors.add(new CallableCollector(i++, this.searcher, this.getDrillDownQuery(query, filters, dim), new FacetsCollectorManager()));
        }
        FacetsCollector[] facetsCollectors = new FacetsCollector[drillDownDims.size()];
        try {
            List futures = this.executor.invokeAll(callableCollectors);
            Object[] mainResults = (Object[])((CallableResult)futures.get(0).get()).result;
            mainFacetsCollector = (FacetsCollector)((Object)mainResults[0]);
            collectorResult = mainResults[1];
            for (i = 1; i < futures.size(); ++i) {
                CallableResult result = (CallableResult)futures.get(i).get();
                facetsCollectors[((CallableResult)result).pos] = (FacetsCollector)((Object)result.result);
            }
            for (i = 0; i < facetsCollectors.length; ++i) {
                if (facetsCollectors[i] != null) continue;
                facetsCollectors[i] = mainFacetsCollector;
            }
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return new ConcurrentDrillSidewaysResult<Object>(this.buildFacetsResult(mainFacetsCollector, facetsCollectors, drillDownDims.keySet().toArray(new String[drillDownDims.size()])), null, collectorResult);
    }

    public static class ConcurrentDrillSidewaysResult<R>
    extends DrillSidewaysResult {
        public final R collectorResult;

        ConcurrentDrillSidewaysResult(Facets facets, TopDocs hits, R collectorResult) {
            super(facets, hits);
            this.collectorResult = collectorResult;
        }
    }

    private static class CallableResult {
        private final int pos;
        private final Object result;

        private CallableResult(int pos, Object result) {
            this.pos = pos;
            this.result = result;
        }
    }

    private static class CallableCollector
    implements Callable<CallableResult> {
        private final int pos;
        private final IndexSearcher searcher;
        private final Query query;
        private final CollectorManager<?, ?> collectorManager;

        private CallableCollector(int pos, IndexSearcher searcher, Query query, CollectorManager<?, ?> collectorManager) {
            this.pos = pos;
            this.searcher = searcher;
            this.query = query;
            this.collectorManager = collectorManager;
        }

        @Override
        public CallableResult call() throws Exception {
            return new CallableResult(this.pos, this.searcher.search(this.query, this.collectorManager));
        }
    }

    public static class DrillSidewaysResult {
        public final Facets facets;
        public final TopDocs hits;

        public DrillSidewaysResult(Facets facets, TopDocs hits) {
            this.facets = facets;
            this.hits = hits;
        }
    }
}

