/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.metrics;

import io.opentelemetry.exporter.otlp.internal.InstrumentationLibraryMarshaler;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.MarshalerUtil;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.ProtoFieldInfo;
import io.opentelemetry.exporter.otlp.internal.ResourceMarshaler;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import io.opentelemetry.exporter.otlp.internal.metrics.InstrumentationLibraryMetricsMarshaler;
import io.opentelemetry.exporter.otlp.internal.metrics.MetricMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.ResourceMetrics;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ResourceMetricsMarshaler
extends MarshalerWithSize {
    private final ResourceMarshaler resourceMarshaler;
    private final byte[] schemaUrl;
    private final InstrumentationLibraryMetricsMarshaler[] instrumentationLibraryMetricsMarshalers;

    public static ResourceMetricsMarshaler[] create(Collection<MetricData> metricDataList) {
        Map<Resource, Map<InstrumentationLibraryInfo, List<Marshaler>>> resourceAndLibraryMap = ResourceMetricsMarshaler.groupByResourceAndLibrary(metricDataList);
        ResourceMetricsMarshaler[] resourceMetricsMarshalers = new ResourceMetricsMarshaler[resourceAndLibraryMap.size()];
        int posResource = 0;
        for (Map.Entry<Resource, Map<InstrumentationLibraryInfo, List<Marshaler>>> entry : resourceAndLibraryMap.entrySet()) {
            InstrumentationLibraryMetricsMarshaler[] instrumentationLibrarySpansMarshalers = new InstrumentationLibraryMetricsMarshaler[entry.getValue().size()];
            int posInstrumentation = 0;
            for (Map.Entry<InstrumentationLibraryInfo, List<Marshaler>> entryIs : entry.getValue().entrySet()) {
                instrumentationLibrarySpansMarshalers[posInstrumentation++] = new InstrumentationLibraryMetricsMarshaler(InstrumentationLibraryMarshaler.create(entryIs.getKey()), MarshalerUtil.toBytes(entryIs.getKey().getSchemaUrl()), entryIs.getValue());
            }
            resourceMetricsMarshalers[posResource++] = new ResourceMetricsMarshaler(ResourceMarshaler.create(entry.getKey()), MarshalerUtil.toBytes(entry.getKey().getSchemaUrl()), instrumentationLibrarySpansMarshalers);
        }
        return resourceMetricsMarshalers;
    }

    ResourceMetricsMarshaler(ResourceMarshaler resourceMarshaler, byte[] schemaUrl, InstrumentationLibraryMetricsMarshaler[] instrumentationLibraryMetricsMarshalers) {
        super(ResourceMetricsMarshaler.calculateSize(resourceMarshaler, schemaUrl, instrumentationLibraryMetricsMarshalers));
        this.resourceMarshaler = resourceMarshaler;
        this.schemaUrl = schemaUrl;
        this.instrumentationLibraryMetricsMarshalers = instrumentationLibraryMetricsMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ResourceMetrics.RESOURCE, this.resourceMarshaler);
        output.serializeRepeatedMessage(ResourceMetrics.INSTRUMENTATION_LIBRARY_METRICS, this.instrumentationLibraryMetricsMarshalers);
        output.serializeString(ResourceMetrics.SCHEMA_URL, this.schemaUrl);
    }

    private static int calculateSize(ResourceMarshaler resourceMarshaler, byte[] schemaUrl, InstrumentationLibraryMetricsMarshaler[] instrumentationLibraryMetricsMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage(ResourceMetrics.RESOURCE, resourceMarshaler);
        size += MarshalerUtil.sizeBytes(ResourceMetrics.SCHEMA_URL, schemaUrl);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ResourceMetrics.INSTRUMENTATION_LIBRARY_METRICS, (Marshaler[])instrumentationLibraryMetricsMarshalers);
    }

    private static Map<Resource, Map<InstrumentationLibraryInfo, List<Marshaler>>> groupByResourceAndLibrary(Collection<MetricData> metricDataList) {
        return MarshalerUtil.groupByResourceAndLibrary(metricDataList, MetricData::getResource, MetricData::getInstrumentationLibraryInfo, MetricMarshaler::create);
    }
}

