/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.Month;
import java.time.MonthDay;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class MonthDayMarshaller
implements ProtoStreamMarshaller<MonthDay> {
    private static final Month[] MONTHS = Month.values();
    private static final MonthDay DEFAULT = MonthDay.of(Month.JANUARY, 1);
    private static final int MONTH_INDEX = 1;
    private static final int DAY_OF_MONTH_INDEX = 2;

    @Override
    public MonthDay readFrom(ProtoStreamReader reader) throws IOException {
        MonthDay result = DEFAULT;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    result = result.with(MONTHS[reader.readEnum()]);
                    continue block4;
                }
                case 2: {
                    result = result.withDayOfMonth(reader.readUInt32() + 1);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return result;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, MonthDay value) throws IOException {
        int dayOfMonth;
        Month month = value.getMonth();
        if (month != DEFAULT.getMonth()) {
            writer.writeEnum(1, month.ordinal());
        }
        if ((dayOfMonth = value.getDayOfMonth()) != DEFAULT.getDayOfMonth()) {
            writer.writeUInt32(2, dayOfMonth - 1);
        }
    }

    @Override
    public Class<? extends MonthDay> getJavaClass() {
        return MonthDay.class;
    }
}

