/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.util.BoundedCollectionExternalizer;

public class CopyOnWriteCollectionExternalizer<T extends Collection<Object>>
implements Externalizer<T> {
    private static final Externalizer<Collection<Object>> COLLECTION_EXTERNALIZER = new BoundedCollectionExternalizer<Collection>(ArrayList.class, ArrayList::new);
    private final Class<T> targetClass;
    private final Function<Collection<Object>, T> factory;

    public CopyOnWriteCollectionExternalizer(Class<?> targetClass, Function<Collection<Object>, T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public OptionalInt size(T collection) {
        return COLLECTION_EXTERNALIZER.size(collection);
    }

    public void writeObject(ObjectOutput output, T collection) throws IOException {
        COLLECTION_EXTERNALIZER.writeObject(output, collection);
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return (T)((Collection)this.factory.apply((Collection<Object>)COLLECTION_EXTERNALIZER.readObject(input)));
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

