/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.util;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SetOfThrowables {
    public static final SetOfThrowables EMPTY = new SetOfThrowables(Collections.emptySet());
    public static final SetOfThrowables ALL = new SetOfThrowables(Collections.singleton(Throwable.class));
    private final Set<Class<? extends Throwable>> classes;

    public static SetOfThrowables create(List<Class<? extends Throwable>> classes) {
        Set<Class<? extends Throwable>> set = Collections.newSetFromMap(new ConcurrentHashMap());
        set.addAll(classes);
        return new SetOfThrowables(set);
    }

    private SetOfThrowables(Set<Class<? extends Throwable>> classes) {
        this.classes = classes;
    }

    public boolean includes(Class<? extends Throwable> searchedFor) {
        for (Class<? extends Throwable> clazz : this.classes) {
            if (!clazz.isAssignableFrom(searchedFor)) continue;
            return true;
        }
        return false;
    }
}

