/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import java.util.EnumSet;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.JaxrsAnnotations;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

public class OpenAPIDependencyProcessor
implements DeploymentUnitProcessor {
    static final AttachmentKey<Boolean> ATTACHMENT_KEY = AttachmentKey.create(Boolean.class);

    public void deploy(DeploymentPhaseContext context) {
        DeploymentUnit unit = context.getDeploymentUnit();
        boolean enabled = DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit) && (unit.getParent() == null || OpenAPIDependencyProcessor.isJaxrsDeployment(unit));
        unit.putAttachment(ATTACHMENT_KEY, (Object)enabled);
        if (enabled) {
            ModuleSpecification specification = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleLoader loader = Module.getBootModuleLoader();
            specification.addSystemDependency(new ModuleDependency(loader, "org.eclipse.microprofile.openapi.api", false, false, false, false));
        }
    }

    public void undeploy(DeploymentUnit unit) {
        unit.removeAttachment(ATTACHMENT_KEY);
    }

    private static boolean isJaxrsDeployment(DeploymentUnit unit) {
        CompositeIndex index = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (JaxrsAnnotations annotation : EnumSet.allOf(JaxrsAnnotations.class)) {
            if (index.getAnnotations(annotation.getDotName()).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

