/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SegmentedCacheServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;

public class DistributedCacheServiceConfigurator
extends SegmentedCacheServiceConfigurator {
    private volatile float capacityFactor;
    private volatile int owners;
    private volatile long l1Lifespan;

    DistributedCacheServiceConfigurator(PathAddress address) {
        super(address, CacheMode.DIST_SYNC);
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.capacityFactor = (float)DistributedCacheResourceDefinition.Attribute.CAPACITY_FACTOR.resolveModelAttribute((ExpressionResolver)context, model).asDouble();
        this.l1Lifespan = DistributedCacheResourceDefinition.Attribute.L1_LIFESPAN.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.owners = DistributedCacheResourceDefinition.Attribute.OWNERS.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        return super.configure(context, model);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        super.accept(builder);
        builder.clustering().hash().capacityFactor(this.capacityFactor).numOwners(this.owners).l1().enabled(this.l1Lifespan > 0L).lifespan(this.l1Lifespan);
    }
}

