/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.converters;

import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.kafka.Record;
import io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata;
import java.lang.reflect.Type;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class RecordConverter
implements MessageConverter {
    public boolean canConvert(Message<?> in, Type target) {
        return in.getMetadata(IncomingKafkaRecordMetadata.class).isPresent() && target.equals(Record.class);
    }

    public Message<?> convert(Message<?> in, Type target) {
        IncomingKafkaRecordMetadata metadata = (IncomingKafkaRecordMetadata)in.getMetadata(IncomingKafkaRecordMetadata.class).orElseThrow(() -> new IllegalStateException("No Kafka metadata"));
        return in.withPayload(Record.of(metadata.getKey(), in.getPayload()));
    }
}

