/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.infinispan.commons.reactive.RxJavaInterop;
import org.infinispan.commons.util.IntSet;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManagerImpl;
import org.infinispan.reactive.publisher.impl.commands.batch.KeyPublisherResponse;
import org.infinispan.reactive.publisher.impl.commands.batch.PublisherResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class InnerPublisherSubscription<K, I, R>
implements LongConsumer,
Action {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final ClusterPublisherManagerImpl.SubscriberHandler<I, R> parent;
    private final int batchSize;
    private final Supplier<Map.Entry<Address, IntSet>> supplier;
    private final Map<Address, Set<K>> excludedKeys;
    private final int topologyId;
    private final FlowableProcessor<R> flowableProcessor;
    private final AtomicLong requestedAmount = new AtomicLong();
    private volatile Map.Entry<Address, IntSet> currentTarget;
    private volatile boolean cancelled;
    private volatile boolean alreadyCreated;

    private InnerPublisherSubscription(ClusterPublisherManagerImpl.SubscriberHandler<I, R> parent, int batchSize, Supplier<Map.Entry<Address, IntSet>> supplier, Map<Address, Set<K>> excludedKeys, int topologyId, FlowableProcessor<R> flowableProcessor, Map.Entry<Address, IntSet> firstTarget) {
        this.parent = parent;
        this.batchSize = batchSize;
        this.supplier = supplier;
        this.excludedKeys = excludedKeys;
        this.topologyId = topologyId;
        this.flowableProcessor = flowableProcessor;
        this.currentTarget = firstTarget;
    }

    static <K, I, R> Publisher<R> createPublisher(ClusterPublisherManagerImpl.SubscriberHandler<I, R> parent, int batchSize, Supplier<Map.Entry<Address, IntSet>> supplier, Map<Address, Set<K>> excludedKeys, int topologyId) {
        return InnerPublisherSubscription.createPublisher(parent, batchSize, supplier, excludedKeys, topologyId, null);
    }

    static <K, I, R> Publisher<R> createPublisher(ClusterPublisherManagerImpl.SubscriberHandler<I, R> parent, int batchSize, Supplier<Map.Entry<Address, IntSet>> supplier, Map<Address, Set<K>> excludedKeys, int topologyId, Map.Entry<Address, IntSet> firstTarget) {
        UnicastProcessor unicastProcessor = UnicastProcessor.create((int)batchSize);
        InnerPublisherSubscription<K, I, R> innerPublisherSubscription = new InnerPublisherSubscription<K, I, R>(parent, batchSize, supplier, excludedKeys, topologyId, unicastProcessor, firstTarget);
        return unicastProcessor.doOnLifecycle(RxJavaInterop.emptyConsumer(), innerPublisherSubscription, innerPublisherSubscription);
    }

    public void run() {
        Map.Entry<Address, IntSet> target;
        this.cancelled = true;
        if (this.alreadyCreated && (target = this.currentTarget) != null) {
            this.parent.sendCancelCommand(target.getKey());
        }
    }

    public void accept(long count) {
        if (this.shouldSubmit(count)) {
            CompletionStage<PublisherResponse> stage;
            if (this.checkCancelled()) {
                return;
            }
            Map.Entry<Address, IntSet> target = this.currentTarget;
            if (target == null) {
                this.alreadyCreated = false;
                target = this.supplier.get();
                if (target == null) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Completing processor %s", this.flowableProcessor);
                    }
                    this.flowableProcessor.onComplete();
                    return;
                }
                this.currentTarget = target;
            }
            Address address = target.getKey();
            IntSet segments = target.getValue();
            try {
                if (this.alreadyCreated) {
                    stage = this.parent.sendNextCommand(address, this.topologyId);
                } else {
                    this.alreadyCreated = true;
                    stage = this.parent.sendInitialCommand(address, segments, this.batchSize, this.excludedKeys.remove(address), this.topologyId);
                }
            }
            catch (Throwable t2) {
                this.handleThrowableInResponse(t2, address, segments);
                return;
            }
            stage.whenComplete((values, t) -> {
                if (t != null) {
                    this.handleThrowableInResponse((Throwable)t, address, segments);
                    return;
                }
                try {
                    KeyPublisherResponse kpr;
                    int extraSize;
                    boolean complete;
                    IntSet lostSegments;
                    IntSet completedSegments;
                    if (log.isTraceEnabled()) {
                        log.tracef("Received %s for id %s from %s", values, this.parent.requestId, address);
                    }
                    if ((completedSegments = values.getCompletedSegments()) != null) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Completed segments %s for id %s from %s", completedSegments, this.parent.requestId, address);
                        }
                        completedSegments.forEach(this.parent::completeSegment);
                        completedSegments.forEach(arg_0 -> ((IntSet)segments).remove(arg_0));
                    }
                    if ((lostSegments = values.getLostSegments()) != null) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Lost segments %s for id %s from %s", completedSegments, this.parent.requestId, address);
                        }
                        lostSegments.forEach(arg_0 -> ((IntSet)segments).remove(arg_0));
                    }
                    if (complete = values.isComplete()) {
                        this.currentTarget = null;
                    } else {
                        int segment = segments.iterator().nextInt();
                        values.forEachSegmentValue(this.parent, segment);
                    }
                    long produced = 0L;
                    Object lastValue = null;
                    Object[] valueArray = values.getResults();
                    if (values instanceof KeyPublisherResponse && (extraSize = (kpr = (KeyPublisherResponse)values).getExtraSize()) > 0) {
                        int arrayLength = valueArray.length;
                        Object[] newArray = new Object[arrayLength + extraSize];
                        System.arraycopy(valueArray, 0, newArray, 0, arrayLength);
                        System.arraycopy(kpr.getExtraObjects(), 0, newArray, arrayLength, extraSize);
                        valueArray = newArray;
                    }
                    for (Object value : valueArray) {
                        if (value == null) break;
                        if (this.checkCancelled()) {
                            return;
                        }
                        this.flowableProcessor.onNext(value);
                        ++produced;
                        lastValue = value;
                    }
                    if (completedSegments != null) {
                        this.parent.notifySegmentsComplete(completedSegments, lastValue);
                    }
                    this.accept(-produced);
                }
                catch (Throwable innerT) {
                    this.handleThrowableInResponse(innerT, address, segments);
                }
            });
        }
    }

    private boolean shouldSubmit(long count) {
        long newValue;
        long prev;
        while (!this.requestedAmount.compareAndSet(prev = this.requestedAmount.get(), newValue = prev + count)) {
        }
        return newValue > 0L && (prev <= 0L || count <= 0L);
    }

    private void handleThrowableInResponse(Throwable t, Address address, IntSet segments) {
        if (this.cancelled) {
            log.tracef("Encountered exception after subscription was cancelled, this can most likely ignored, message is %s", t.getMessage());
        } else if (this.parent.handleThrowable(t, address, segments)) {
            this.currentTarget = null;
            this.accept(0L);
        } else {
            this.flowableProcessor.onError(t);
        }
    }

    private boolean checkCancelled() {
        if (this.cancelled) {
            if (log.isTraceEnabled()) {
                log.tracef("Subscription %s was cancelled, terminating early", this);
            }
            return true;
        }
        return false;
    }
}

