/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.warupdater;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXMLDocumentHelper {
    protected static Element getChildElement(Element element, String tagName) {
        NodeList childNodes = element.getChildNodes();
        int numChildren = childNodes.getLength();
        for (int i = 0; i < numChildren; ++i) {
            String childTagName;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            if (tagName != null && !(childTagName = childElement.getTagName()).equals(tagName)) continue;
            return childElement;
        }
        return null;
    }

    public static List getChildElements(Element element, String tagName) {
        List<Node> elements = WebXMLDocumentHelper.getElementList(element);
        int numElements = elements.size();
        ArrayList<Element> childElements = new ArrayList<Element>();
        for (int i = 0; i < numElements; ++i) {
            String childTagName;
            Element childElement = (Element)elements.get(i);
            if (tagName != null && !(childTagName = childElement.getTagName()).equals(tagName)) continue;
            childElements.add(childElement);
        }
        return childElements;
    }

    protected static List<Node> getElementList(Element element) {
        ArrayList<Node> elementList = new ArrayList<Node>();
        NodeList childNodes = element.getChildNodes();
        int numChildren = childNodes.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            elementList.add(childNode);
        }
        return elementList;
    }

    public static String getChildTextTrim(Element element, String tagName) {
        Element childElement = WebXMLDocumentHelper.getChildElement(element, tagName);
        if (childElement != null) {
            return WebXMLDocumentHelper.getTextTrim(childElement);
        }
        return null;
    }

    public static String getTextTrim(Element element) {
        Node node = element.getChildNodes().item(0);
        if (node != null && node.getNodeType() == 3) {
            return node.getNodeValue().trim();
        }
        return "";
    }

    protected static Map getAttributeTable(Element element) {
        HashMap<String, String> attributeTable = new HashMap<String, String>();
        NamedNodeMap attrs = element.getAttributes();
        if (attrs != null) {
            int numAttrs = attrs.getLength();
            for (int i = 0; i < numAttrs; ++i) {
                Node na = attrs.item(i);
                if (na.getNodeType() != 2) continue;
                Attr a = (Attr)na;
                attributeTable.put(a.getName(), a.getValue());
            }
        }
        return attributeTable;
    }

    protected static Element createElement(Document d, String tagName) {
        Element e = d.createElement(tagName);
        return e;
    }

    public static void addContent(Element root, List newchildren) {
        Iterator it = newchildren.iterator();
        while (it.hasNext()) {
            root.appendChild((Node)it.next());
        }
    }

    public static void addContent(Element root, Element child) {
        root.appendChild(child);
    }

    public static void addContent(Element root, Document doc, String text) {
        Text textNode = doc.createTextNode(text);
        root.appendChild(textNode);
    }

    public static void insertContent(Element root, List newchildren) {
        Node firstChild = root.getFirstChild();
        Iterator it = newchildren.iterator();
        while (it.hasNext()) {
            root.insertBefore((Node)it.next(), firstChild);
        }
    }
}

