/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.portlet.impl.RDRequestWrapper;
import com.sun.portal.portletcontainer.portlet.impl.RDResponseWrapper;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestDispatcherImpl
implements PortletRequestDispatcher {
    private RequestDispatcher servletRD;
    private boolean namedDispatcher = true;
    private ServletContext servletContext;
    private static Logger logger = ContainerLogger.getLogger(PortletRequestDispatcherImpl.class, (String)"PAELogMessages");
    private String queryString;
    private String servletPath;
    private String pathInfo;

    public PortletRequestDispatcherImpl(ServletContext servletContext, RequestDispatcher servletRD) {
        this.servletRD = servletRD;
        this.servletContext = servletContext;
    }

    public PortletRequestDispatcherImpl(ServletContext servletContext, RequestDispatcher servletRD, List<String> servletURLPatterns, String path) {
        this(servletContext, servletRD);
        this.namedDispatcher = false;
        if (path != null) {
            String pathWithoutQueryString = path;
            int questionIndex = path.indexOf("?");
            if (questionIndex != -1) {
                pathWithoutQueryString = path.substring(0, questionIndex);
                this.queryString = path.substring(questionIndex + 1, path.length());
            }
            if (servletURLPatterns != null) {
                for (String urlPattern : servletURLPatterns) {
                    int urlPatternIndex;
                    if (!urlPattern.endsWith("/*") || !pathWithoutQueryString.startsWith(urlPattern = urlPattern.substring(0, urlPatternIndex = urlPattern.indexOf("/*")))) continue;
                    this.pathInfo = pathWithoutQueryString.substring(urlPattern.length());
                    this.servletPath = urlPattern;
                    break;
                }
            }
            if (this.pathInfo == null && this.servletPath == null) {
                this.pathInfo = "";
                this.servletPath = pathWithoutQueryString;
            }
        }
    }

    public void include(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.dispatch((PortletRequest)request, (PortletResponse)response, true);
    }

    public void include(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        this.dispatch(request, response, true);
    }

    public void forward(PortletRequest request, PortletResponse response) throws PortletException, IOException, IllegalStateException {
        this.dispatch(request, response, false);
    }

    protected void dispatch(PortletRequest request, PortletResponse response, boolean include) throws PortletException, IOException {
        String lifecyclePhase = this.getLifecyclePhase(request);
        RDRequestWrapper rdRequestWrapper = this.getRDRequestWrapper(lifecyclePhase, request, include);
        RDResponseWrapper rdResponseWrapper = this.getRDResponseWrapper(lifecyclePhase, rdRequestWrapper, response, include);
        if (rdRequestWrapper == null || rdResponseWrapper == null) {
            throw new NullPointerException("No request/response wrappers found");
        }
        this.setRequestResponseAttributes(rdRequestWrapper, request, response);
        try {
            if (include) {
                this.servletRD.include((ServletRequest)rdRequestWrapper, (ServletResponse)rdResponseWrapper);
            } else {
                this.servletRD.forward((ServletRequest)rdRequestWrapper, (ServletResponse)rdResponseWrapper);
            }
        }
        catch (ServletException se) {
            throw new PortletException("A ServletException was thrown in the target servlet or JSP.", (Throwable)se);
        }
    }

    private RDRequestWrapper getRDRequestWrapper(String lifecyclePhase, PortletRequest portletRequest, boolean include) {
        String contextPath = portletRequest.getContextPath();
        String requestURI = this.getRequestURI(contextPath, this.servletPath, this.pathInfo);
        this.logAttributes(requestURI, contextPath, this.servletPath, this.pathInfo, this.queryString);
        HttpServletRequest request = (HttpServletRequest)portletRequest.getAttribute("javax.portlet.portletc.httpServletRequest");
        RDRequestWrapper rdRequestWrapper = new RDRequestWrapper(this.servletContext, request, portletRequest, requestURI, this.servletPath, this.pathInfo, this.queryString, lifecyclePhase, include, this.namedDispatcher);
        return rdRequestWrapper;
    }

    private RDResponseWrapper getRDResponseWrapper(String lifecyclePhase, RDRequestWrapper rdRequestWrapper, PortletResponse portletResponse, boolean include) {
        HttpServletResponse response = (HttpServletResponse)rdRequestWrapper.getAttribute("javax.portlet.portletc.httpServletResponse");
        RDResponseWrapper rdResponseWrapper = new RDResponseWrapper(response, portletResponse, lifecyclePhase, include);
        return rdResponseWrapper;
    }

    private String getLifecyclePhase(PortletRequest portletRequest) {
        return (String)portletRequest.getAttribute("javax.portlet.lifecycle_phase");
    }

    private String getRequestURI(String contextPath, String servletPath, String pathInfo) {
        StringBuffer requestURI = new StringBuffer();
        requestURI.append(contextPath);
        if (servletPath != null) {
            requestURI.append(servletPath);
        }
        if (pathInfo != null) {
            requestURI.append(pathInfo);
        }
        return requestURI.toString();
    }

    private void logAttributes(String requestURI, String contextPath, String servletPath, String pathInfo, String queryString) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSPL_PAECSPPI0047", new String[]{requestURI, contextPath, servletPath, pathInfo, queryString});
        }
    }

    private void setRequestResponseAttributes(RDRequestWrapper rdRequestWrapper, PortletRequest portletRequest, PortletResponse portletResponse) {
        rdRequestWrapper.setAttribute("javax.portlet.request", portletRequest);
        rdRequestWrapper.setAttribute("javax.portlet.response", portletResponse);
    }
}

