/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.portlet.impl.PayloadObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class EventPayload {
    private static Logger logger = ContainerLogger.getLogger(EventPayload.class, (String)"PAELogMessages");
    private QName eventQName;
    private byte[] eventValueBytes;
    private Serializable eventValueObject;
    private boolean serialize;

    public EventPayload(QName qname, String valueType) {
        this.eventQName = qname;
        this.serialize = this.doesValueNeedSerialization(valueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePayload(Serializable value) {
        if (this.serialize) {
            ByteArrayOutputStream baos = null;
            ObjectOutputStream out = null;
            try {
                baos = new ByteArrayOutputStream();
                out = new ObjectOutputStream(baos);
                out.writeObject(value);
                this.eventValueBytes = baos.toByteArray();
                return;
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) return;
                LogRecord record = new LogRecord(Level.SEVERE, "PSPL_PAECSPPA0022");
                record.setLoggerName(logger.getName());
                record.setThrown(e);
                record.setParameters(new Object[]{this.eventQName});
                logger.log(record);
                return;
            }
            finally {
                try {
                    if (baos != null) {
                        baos.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        this.eventValueObject = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Serializable getPayload() {
        Serializable value = null;
        if (!this.serialize) return this.eventValueObject;
        if (this.eventValueBytes != null) {
            ByteArrayInputStream bais = null;
            ObjectInputStream in = null;
            try {
                bais = new ByteArrayInputStream(this.eventValueBytes);
                in = new PayloadObjectInputStream(Thread.currentThread().getContextClassLoader(), bais);
                value = (Serializable)in.readObject();
                return value;
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) return value;
                LogRecord record = new LogRecord(Level.SEVERE, "PSPL_PAECSPPA0024");
                record.setLoggerName(logger.getName());
                record.setThrown(e);
                record.setParameters(new Object[]{this.eventQName});
                logger.log(record);
                return value;
            }
            finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        logger.log(Level.SEVERE, "PSPL_PAECSPPA0025", this.eventQName);
        return value;
    }

    private boolean doesValueNeedSerialization(String valueType) {
        return !valueType.startsWith("java.lang");
    }
}

