/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.VendorPortletXML;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentExtensionDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletLSResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SunPortletXMLImpl
implements VendorPortletXML {
    private String version;
    private static Logger logger = ContainerLogger.getLogger(SunPortletXMLImpl.class, (String)"PCCLogMessages");
    public static final String SUN_PORTAL_NAMESPACE = "http://www.sun.com/software/xml/ns/portal_server";
    private static String SUN_PORTLET_SCHEMA_FILE = "sun-portlet.xsd";
    private static Schema schema;

    public Object processDeploy(File warFile, InputStream vendorPortletXMLStream, String schemaLocation, boolean validate) throws Exception {
        return this.loadPortletExtensionDescriptor(vendorPortletXMLStream, schemaLocation, validate);
    }

    public void processUndeploy(InputStream vendorPortletXMLStream) throws Exception {
    }

    public Object loadPortletExtensionDescriptor(InputStream vendorPortletXMLStream) throws Exception {
        return this.loadPortletExtensionDescriptor(vendorPortletXMLStream, null, false);
    }

    public Object loadPortletExtensionDescriptor(InputStream vendorPortletXMLStream, String schemaLocation, boolean validate) throws Exception {
        Element root;
        DeploymentExtensionDescriptor extensionDescriptor = null;
        if (vendorPortletXMLStream != null && (root = this.readPortletExtensionDescriptor(vendorPortletXMLStream, schemaLocation, validate)) != null) {
            extensionDescriptor = new DeploymentExtensionDescriptor();
            extensionDescriptor.load(root, SUN_PORTAL_NAMESPACE);
        }
        return extensionDescriptor;
    }

    public Element readPortletExtensionDescriptor(InputStream vendorPortletXMLStream, String schemaLocation, boolean validate) throws DeploymentDescriptorException {
        Element element;
        block9: {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSPL_PCCCSPPCCD0023", Boolean.toString(validate));
            }
            element = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder docBuilder = dbf.newDocumentBuilder();
                Document document = docBuilder.parse(vendorPortletXMLStream);
                element = document.getDocumentElement();
                if (element != null && element.hasAttribute("version")) {
                    this.version = element.getAttribute("version");
                }
                if (!validate) break block9;
                Schema sunSchema = null;
                try {
                    sunSchema = SunPortletXMLImpl.getSunPortletSchema(schemaLocation, SUN_PORTLET_SCHEMA_FILE);
                }
                catch (SAXException saxe) {
                    logger.log(Level.WARNING, "PSPL_PCCCSPPCCD0024", saxe);
                }
                if (sunSchema != null) {
                    Validator validator = sunSchema.newValidator();
                    validator.validate(new DOMSource(document));
                }
            }
            catch (ParserConfigurationException pce) {
                logger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0003", pce);
                throw new DeploymentDescriptorException("error reading stream", pce);
            }
            catch (SAXException saxe) {
                logger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0003", saxe);
                throw new DeploymentDescriptorException("error reading stream", saxe);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0003", e);
                throw new DeploymentDescriptorException("error reading stream", e);
            }
        }
        return element;
    }

    public static Schema getSunPortletSchema(String schemaLocation, String schemaFilename) throws SAXException {
        if (schema == null) {
            InputStream sunPortletSchemaStream = null;
            try {
                sunPortletSchemaStream = new FileInputStream(schemaLocation + File.separator + schemaFilename);
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                factory.setResourceResolver(new PortletLSResourceResolver());
                StreamSource schemaFile = new StreamSource(sunPortletSchemaStream);
                schema = factory.newSchema(schemaFile);
            }
            catch (FileNotFoundException ex) {
                throw new SAXException(ex);
            }
            finally {
                try {
                    sunPortletSchemaStream.close();
                }
                catch (IOException ex) {}
            }
        }
        return schema;
    }
}

