/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class PreferenceDescriptor {
    private String prefName;
    private List<String> prefValues = new ArrayList<String>();
    private List<String> descriptions = new ArrayList<String>();
    private boolean readOnly = false;
    private boolean multiValue = false;
    private String portletName;
    private static Logger logger = ContainerLogger.getLogger(PreferenceDescriptor.class, (String)"PCCLogMessages");

    public PreferenceDescriptor(String portletName) {
        this.portletName = portletName;
    }

    public void load(Element element, String namespaceURI) {
        Element multiValueElement;
        List<Element> prefValueElements;
        this.prefName = PortletXMLDocumentHelper.getChildTextTrim(element, "name");
        if (this.prefName == null) {
            logger.log(Level.WARNING, "PSPL_PCCCSPPCCD0011", this.portletName);
        }
        if ((prefValueElements = PortletXMLDocumentHelper.getChildElements(element, "value")).isEmpty()) {
            logger.log(Level.WARNING, "PSPL_PCCCSPPCCD0012", new String[]{this.prefName, this.portletName});
        } else {
            int numPrefValue = prefValueElements.size();
            for (int i = 0; i < numPrefValue; ++i) {
                Element prefValueElement = prefValueElements.get(i);
                this.prefValues.add(PortletXMLDocumentHelper.getTextTrim(prefValueElement));
            }
        }
        List<Element> descriptionElements = PortletXMLDocumentHelper.getChildElements(element, "description");
        int numDescription = descriptionElements.size();
        for (int i = 0; i < numDescription; ++i) {
            Element descriptionElement = descriptionElements.get(i);
            this.descriptions.add(PortletXMLDocumentHelper.getTextTrim(descriptionElement));
        }
        String readOnly = PortletXMLDocumentHelper.getChildTextTrim(element, "read-only");
        if (readOnly != null && readOnly.equals("true")) {
            this.readOnly = true;
        }
        if ((multiValueElement = PortletXMLDocumentHelper.getChildElement(element, "multi-value")) != null) {
            this.multiValue = true;
        }
    }

    public String getPrefName() {
        return this.prefName;
    }

    public List getPrefValues() {
        return this.prefValues;
    }

    public String getDescription() {
        String description = null;
        if (!this.descriptions.isEmpty()) {
            description = this.descriptions.get(0);
        }
        return description;
    }

    public List getDescriptions() {
        return this.descriptions;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean getMultiValueFlag() {
        return this.multiValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PreferenceDescriptor [");
        sb.append(" preference name [");
        if (this.prefName != null) {
            sb.append(this.prefName);
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" preference values [");
        Iterator<String> iterator = this.prefValues.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
        }
        sb.append("]");
        sb.append(" description [");
        if (!this.descriptions.isEmpty()) {
            sb.append(this.descriptions.get(0));
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" read-only [");
        if (this.readOnly) {
            sb.append("fase");
        } else {
            sb.append("true");
        }
        sb.append("]");
        sb.append("]");
        sb.append("\n");
        return sb.toString();
    }
}

