/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.PortletID;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletsDescriptor {
    private String portletAppName;
    private List<PortletDescriptor> portletDescriptors;
    private List<String> portletNames;
    private List<PortletID> portletIDs;
    private Map<PortletID, List<QName>> processingEvents;
    private Map<PortletID, List<QName>> publishingEvents;
    private Map<PortletID, List<String>> publicRenderParameterIdentifiers;
    private static Logger logger = ContainerLogger.getLogger(PortletsDescriptor.class, (String)"PCCLogMessages");

    public PortletsDescriptor(String portletAppName) {
        this.portletAppName = portletAppName;
    }

    public void load(Element element, String namespaceURI, String defaultEventNameSpace) throws DeploymentDescriptorException {
        NodeList portletElements = element.getElementsByTagName("portlet");
        if (portletElements.getLength() == 0) {
            logger.warning("PSPL_PCCCSPPCCD0010");
        } else {
            this.portletDescriptors = new ArrayList<PortletDescriptor>(portletElements.getLength());
            this.portletNames = new ArrayList<String>(portletElements.getLength());
            this.portletIDs = new ArrayList<PortletID>(portletElements.getLength());
            this.processingEvents = new LinkedHashMap<PortletID, List<QName>>();
            this.publishingEvents = new LinkedHashMap<PortletID, List<QName>>();
            this.publicRenderParameterIdentifiers = new LinkedHashMap<PortletID, List<String>>();
        }
        for (int i = 0; i < portletElements.getLength(); ++i) {
            Element portletElement = (Element)portletElements.item(i);
            PortletDescriptor portletDescriptor = new PortletDescriptor(this.portletAppName);
            portletDescriptor.load(portletElement, namespaceURI, defaultEventNameSpace);
            this.portletDescriptors.add(portletDescriptor);
            this.portletNames.add(portletDescriptor.getPortletName());
            PortletID portletID = new PortletID(this.portletAppName, portletDescriptor.getPortletName());
            this.portletIDs.add(portletID);
            if (portletDescriptor.getSupportedProcessingEvents() != null && !portletDescriptor.getSupportedProcessingEvents().isEmpty()) {
                this.processingEvents.put(portletID, portletDescriptor.getSupportedProcessingEvents());
            }
            if (portletDescriptor.getSupportedPublishingEvents() != null && !portletDescriptor.getSupportedPublishingEvents().isEmpty()) {
                this.publishingEvents.put(portletID, portletDescriptor.getSupportedPublishingEvents());
            }
            if (portletDescriptor.getSupportedPublicRenderParameterIdentifiers() == null || portletDescriptor.getSupportedPublicRenderParameterIdentifiers().isEmpty()) continue;
            this.publicRenderParameterIdentifiers.put(portletID, portletDescriptor.getSupportedPublicRenderParameterIdentifiers());
        }
    }

    public List<String> getPortletNames() {
        return this.portletNames;
    }

    public List<PortletID> getPortletIDs() {
        return this.portletIDs;
    }

    protected Map<PortletID, List<QName>> getPortletProcessingEvents() {
        return this.processingEvents;
    }

    protected Map<PortletID, List<QName>> getPortletPublishingEvents() {
        return this.publishingEvents;
    }

    public Map<PortletID, List<String>> getPortletPublicRenderParameterIdentifiers() {
        return this.publicRenderParameterIdentifiers;
    }

    public List<PortletDescriptor> getPortletDescriptors() {
        return this.portletDescriptors;
    }

    public PortletDescriptor getPortletDescriptor(String portletName) {
        PortletDescriptor portlet = null;
        boolean stop = false;
        Iterator<PortletDescriptor> iterator = this.portletDescriptors.iterator();
        while (iterator.hasNext() && !stop) {
            PortletDescriptor portletDescriptor = iterator.next();
            if (!portletDescriptor.getPortletName().equals(portletName)) continue;
            portlet = portletDescriptor;
            stop = true;
        }
        return portlet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletsDescriptor [");
        for (PortletDescriptor portletDescriptor : this.portletDescriptors) {
            sb.append(portletDescriptor.toString());
            sb.append("\n");
        }
        sb.append("]");
        sb.append("\n");
        return sb.toString();
    }
}

