/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.common.descriptor.PortletLSResourceResolver;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class PortletSchema {
    private static Logger logger = ContainerLogger.getLogger(PortletSchema.class, (String)"PCCLogMessages");
    private static final String PORTLET_V1_SCHEMA_FILE = "portlet-app_1_0.xsd";
    private static final String PORTLET_V2_SCHEMA_FILE = "portlet-app_2_0.xsd";
    private static Map<String, Schema> schemas = new HashMap<String, Schema>();

    public static Schema getSchema(String version) {
        if (schemas != null) {
            return schemas.get(version);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateSchema(String version, String schemaFilename) {
        InputStream schemaStream = null;
        try {
            schemaStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaFilename);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setResourceResolver(new PortletLSResourceResolver());
            StreamSource schemaFile = new StreamSource(schemaStream);
            Schema schema = factory.newSchema(schemaFile);
            schemas.put(version, schema);
        }
        catch (Exception ex) {
            if (logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSPL_PCCCSPPCCD0019");
                record.setParameters(new String[]{version, schemaFilename});
                record.setThrown(ex);
                record.setLoggerName(logger.getName());
                logger.log(record);
            }
        }
        finally {
            try {
                if (schemaStream != null) {
                    schemaStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static {
        PortletSchema.generateSchema("1.0", PORTLET_V1_SCHEMA_FILE);
        PortletSchema.generateSchema("2.0", PORTLET_V2_SCHEMA_FILE);
    }
}

