/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.PortletID;
import com.sun.portal.container.service.EventHolder;
import com.sun.portal.container.service.PublicRenderParameterHolder;
import com.sun.portal.portletcontainer.common.descriptor.CustomPortletModeDecriptor;
import com.sun.portal.portletcontainer.common.descriptor.CustomWindowStateDecriptor;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainer.common.descriptor.EventDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.FilterDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.FilterMappingDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import com.sun.portal.portletcontainer.common.descriptor.PortletsDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PublicRenderParameterDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.SecurityConstraintDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.URLListenerDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.UserAttributeDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.portlet.PortletURLGenerationListener;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletAppDescriptor {
    private List<String> descriptions;
    private List<String> displayNames;
    private PortletsDescriptor portletsDescriptor;
    private SecurityConstraintDescriptor secConstraintDescriptor;
    private List<UserAttributeDescriptor> userAttributeDescriptors;
    private List<FilterDescriptor> filterDescriptors;
    private List<FilterMappingDescriptor> filterMappingDescriptors;
    private List<EventDescriptor> eventDescriptors;
    private Map<QName, EventDescriptor> eventDescriptorMap;
    private Map<PortletID, List<EventHolder>> processingEventMap;
    private Map<PortletID, List<EventHolder>> publishingEventMap;
    private List<PublicRenderParameterDescriptor> publicRPDescriptors;
    private Map<PortletID, List<PublicRenderParameterHolder>> publicRenderParametersMap;
    private List<CustomPortletModeDecriptor> customPortletModeDecriptors;
    private List<CustomWindowStateDecriptor> customWindowStateDecriptors;
    private List<URLListenerDescriptor> urlListenerDescriptors;
    private Map<String, String[]> containerRuntimeOptions;
    private String defaultNameSpace;
    private String version;
    private String id;
    private String portletAppName;
    private List<String> servletURLPatterns;

    public PortletAppDescriptor(String portletAppName) {
        this.portletAppName = portletAppName;
    }

    public void load(Element root, String namespaceURI) throws DeploymentDescriptorException {
        NodeList listenerElements;
        NodeList publicRPElements;
        NodeList eventElements;
        Element secConstraintElement;
        List<Element> displayNameElements;
        List<Element> descriptionElements;
        List<Element> customWindowStateElements;
        if (root.hasAttribute("version")) {
            this.version = root.getAttribute("version");
        }
        this.id = PortletXMLDocumentHelper.getId(root);
        List<Element> customPortletModeElements = PortletXMLDocumentHelper.getChildElements(root, "custom-portlet-mode");
        if (customPortletModeElements.size() > 0) {
            this.customPortletModeDecriptors = new ArrayList<CustomPortletModeDecriptor>(customPortletModeElements.size());
            for (int i = 0; i < customPortletModeElements.size(); ++i) {
                Element cpmElement = customPortletModeElements.get(i);
                CustomPortletModeDecriptor cpmDisc = new CustomPortletModeDecriptor();
                cpmDisc.load(cpmElement, namespaceURI);
                this.customPortletModeDecriptors.add(cpmDisc);
            }
        }
        if ((customWindowStateElements = PortletXMLDocumentHelper.getChildElements(root, "custom-window-state")).size() > 0) {
            this.customWindowStateDecriptors = new ArrayList<CustomWindowStateDecriptor>(customWindowStateElements.size());
            for (int i = 0; i < customWindowStateElements.size(); ++i) {
                Element cwsElement = customWindowStateElements.get(i);
                CustomWindowStateDecriptor cwsDisc = new CustomWindowStateDecriptor();
                cwsDisc.load(cwsElement, namespaceURI);
                this.customWindowStateDecriptors.add(cwsDisc);
            }
        }
        if ((descriptionElements = PortletXMLDocumentHelper.getChildElements(root, "description")).size() > 0) {
            this.descriptions = new ArrayList<String>(descriptionElements.size());
            for (int i = 0; i < descriptionElements.size(); ++i) {
                this.descriptions.add(PortletXMLDocumentHelper.getTextTrim(descriptionElements.get(i)));
            }
        }
        if ((displayNameElements = PortletXMLDocumentHelper.getChildElements(root, "display-name")).size() > 0) {
            this.displayNames = new ArrayList<String>(displayNameElements.size());
            for (int i = 0; i < displayNameElements.size(); ++i) {
                Element displayNameElement = displayNameElements.get(i);
                this.displayNames.add(PortletXMLDocumentHelper.getTextTrim(displayNameElement));
            }
        }
        this.defaultNameSpace = PortletXMLDocumentHelper.getChildTextTrim(root, "default-namespace");
        if (this.defaultNameSpace == null) {
            this.defaultNameSpace = "";
        }
        this.portletsDescriptor = new PortletsDescriptor(this.portletAppName);
        this.portletsDescriptor.load(root, namespaceURI, this.defaultNameSpace);
        NodeList userAttrElements = root.getElementsByTagName("user-attribute");
        if (userAttrElements.getLength() > 0) {
            this.userAttributeDescriptors = new ArrayList<UserAttributeDescriptor>(userAttrElements.getLength());
            for (int i = 0; i < userAttrElements.getLength(); ++i) {
                Element userAttrElement = (Element)userAttrElements.item(i);
                UserAttributeDescriptor userAttrDescriptor = new UserAttributeDescriptor();
                userAttrDescriptor.load(userAttrElement, namespaceURI);
                this.userAttributeDescriptors.add(userAttrDescriptor);
            }
        }
        if ((secConstraintElement = PortletXMLDocumentHelper.getChildElement(root, "security-constraint")) != null) {
            this.secConstraintDescriptor = new SecurityConstraintDescriptor();
            this.secConstraintDescriptor.load(secConstraintElement, namespaceURI);
        }
        NodeList filterElements = root.getElementsByTagName("filter");
        NodeList filterMappingElements = root.getElementsByTagName("filter-mapping");
        if (filterElements.getLength() > 0 & filterMappingElements.getLength() > 0) {
            int i;
            this.filterDescriptors = new ArrayList<FilterDescriptor>(filterElements.getLength());
            this.filterMappingDescriptors = new ArrayList<FilterMappingDescriptor>(filterMappingElements.getLength());
            for (i = 0; i < filterElements.getLength(); ++i) {
                Element filterElement = (Element)filterElements.item(i);
                FilterDescriptor filterDescriptor = new FilterDescriptor();
                filterDescriptor.load(filterElement, namespaceURI);
                this.filterDescriptors.add(filterDescriptor);
            }
            for (i = 0; i < filterMappingElements.getLength(); ++i) {
                Element filterMappingElement = (Element)filterMappingElements.item(i);
                FilterMappingDescriptor filterMappingDescriptor = new FilterMappingDescriptor();
                filterMappingDescriptor.load(filterMappingElement, namespaceURI);
                this.filterMappingDescriptors.add(filterMappingDescriptor);
            }
        }
        if ((eventElements = root.getElementsByTagName("event-definition")).getLength() > 0) {
            this.eventDescriptors = new ArrayList<EventDescriptor>(eventElements.getLength());
            this.eventDescriptorMap = new HashMap<QName, EventDescriptor>(eventElements.getLength());
            for (int i = 0; i < eventElements.getLength(); ++i) {
                Element eventElement = (Element)eventElements.item(i);
                EventDescriptor eventDescriptor = new EventDescriptor();
                eventDescriptor.load(eventElement, namespaceURI, this.defaultNameSpace);
                this.eventDescriptors.add(eventDescriptor);
                if (eventDescriptor.getQName() == null) continue;
                this.eventDescriptorMap.put(eventDescriptor.getQName(), eventDescriptor);
            }
            this.processingEventMap = this.getEventMap(this.getPortletsDescriptor().getPortletProcessingEvents());
            this.publishingEventMap = this.getEventMap(this.getPortletsDescriptor().getPortletPublishingEvents());
        }
        if ((publicRPElements = root.getElementsByTagName("public-render-parameter")).getLength() > 0) {
            this.publicRPDescriptors = new ArrayList<PublicRenderParameterDescriptor>(publicRPElements.getLength());
            for (int i = 0; i < publicRPElements.getLength(); ++i) {
                Element publicRPElement = (Element)publicRPElements.item(i);
                PublicRenderParameterDescriptor publicRPDescriptor = new PublicRenderParameterDescriptor();
                publicRPDescriptor.load(publicRPElement, namespaceURI, this.defaultNameSpace);
                this.publicRPDescriptors.add(publicRPDescriptor);
            }
            Map<PortletID, List<String>> publicRenderParametersIdentifiers = this.getPortletsDescriptor().getPortletPublicRenderParameterIdentifiers();
            this.publicRenderParametersMap = new HashMap<PortletID, List<PublicRenderParameterHolder>>(publicRenderParametersIdentifiers.size());
            Set<Map.Entry<PortletID, List<String>>> entries = publicRenderParametersIdentifiers.entrySet();
            for (Map.Entry<PortletID, List<String>> mapEntry : entries) {
                List<String> identifiers = mapEntry.getValue();
                ArrayList<PublicRenderParameterHolder> publicRenderParameterHolders = new ArrayList<PublicRenderParameterHolder>(identifiers.size());
                for (PublicRenderParameterDescriptor publicRPDescriptor : this.publicRPDescriptors) {
                    if (!identifiers.contains(publicRPDescriptor.getIdentifier())) continue;
                    publicRenderParameterHolders.add(publicRPDescriptor.getPublicRenderParameterHolder());
                }
                this.publicRenderParametersMap.put(mapEntry.getKey(), publicRenderParameterHolders);
            }
        }
        if ((listenerElements = root.getElementsByTagName("listener")).getLength() > 0) {
            this.urlListenerDescriptors = new ArrayList<URLListenerDescriptor>(listenerElements.getLength());
            for (int i = 0; i < listenerElements.getLength(); ++i) {
                Element listenerElement = (Element)listenerElements.item(i);
                URLListenerDescriptor urlListenerDescriptor = new URLListenerDescriptor();
                urlListenerDescriptor.load(listenerElement, namespaceURI);
                this.urlListenerDescriptors.add(urlListenerDescriptor);
            }
        }
        this.containerRuntimeOptions = PortletXMLDocumentHelper.getRuntimeOptions(root);
    }

    public String getName() {
        return this.portletAppName;
    }

    public PortletsDescriptor getPortletsDescriptor() {
        return this.portletsDescriptor;
    }

    public List<UserAttributeDescriptor> getUserAttributeDescriptors() {
        if (this.userAttributeDescriptors == null) {
            return Collections.emptyList();
        }
        return this.userAttributeDescriptors;
    }

    public List<FilterDescriptor> getFilterDescriptors() {
        if (this.filterDescriptors == null) {
            return Collections.emptyList();
        }
        return this.filterDescriptors;
    }

    public List<FilterMappingDescriptor> getFilterMappingDescriptors() {
        if (this.filterMappingDescriptors == null) {
            return Collections.emptyList();
        }
        return this.filterMappingDescriptors;
    }

    public List<EventDescriptor> getEventDescriptors() {
        if (this.eventDescriptors == null) {
            return Collections.emptyList();
        }
        return this.eventDescriptors;
    }

    public EventDescriptor getEventDescriptor(QName qName) {
        if (this.eventDescriptorMap == null || qName == null) {
            return null;
        }
        return this.eventDescriptorMap.get(qName);
    }

    public Map<PortletID, List<EventHolder>> getProcessingEvents() {
        if (this.processingEventMap == null) {
            return Collections.emptyMap();
        }
        return this.processingEventMap;
    }

    public Map<PortletID, List<QName>> getSupportedProcessingEvents() {
        return this.getPortletsDescriptor().getPortletProcessingEvents();
    }

    public Map<PortletID, List<EventHolder>> getPublishingEvents() {
        if (this.publishingEventMap == null) {
            return Collections.emptyMap();
        }
        return this.publishingEventMap;
    }

    public List<PublicRenderParameterDescriptor> getPublicRenderParameterDescriptors() {
        if (this.publicRPDescriptors == null) {
            return Collections.emptyList();
        }
        return this.publicRPDescriptors;
    }

    public Map<PortletID, List<PublicRenderParameterHolder>> getPublicRenderParameters() {
        if (this.publicRenderParametersMap == null) {
            return Collections.emptyMap();
        }
        return this.publicRenderParametersMap;
    }

    public String getPublicRenderParameterIdentifier(QName publicRenderParameterQName) {
        List<PublicRenderParameterDescriptor> publicRenderParameterDescriptors = this.getPublicRenderParameterDescriptors();
        for (PublicRenderParameterDescriptor publicRenderParameterDescriptor : publicRenderParameterDescriptors) {
            if (!publicRenderParameterDescriptor.getQName().equals(publicRenderParameterQName)) continue;
            return publicRenderParameterDescriptor.getIdentifier();
        }
        return null;
    }

    public QName getPublicRenderParameterQName(String publicRenderParameterIdentifier) {
        List<PublicRenderParameterDescriptor> publicRenderParameterDescriptors = this.getPublicRenderParameterDescriptors();
        for (PublicRenderParameterDescriptor publicRenderParameterDescriptor : publicRenderParameterDescriptors) {
            if (!publicRenderParameterDescriptor.getIdentifier().equals(publicRenderParameterIdentifier)) continue;
            return publicRenderParameterDescriptor.getQName();
        }
        return null;
    }

    public String getPortletAppDescription() {
        String description = null;
        if (!this.descriptions.isEmpty()) {
            description = this.descriptions.get(0);
        }
        return description;
    }

    public List<String> getPortletAppDescriptions() {
        if (this.descriptions == null) {
            return Collections.emptyList();
        }
        return this.descriptions;
    }

    public List<String> getPortletAppDisplayNames() {
        if (this.displayNames == null) {
            return Collections.emptyList();
        }
        return this.displayNames;
    }

    public SecurityConstraintDescriptor getSecurityConstraintDescriptor() {
        return this.secConstraintDescriptor;
    }

    private Map<String, String[]> getContainerRuntimeOptions() {
        if (this.containerRuntimeOptions == null) {
            return Collections.emptyMap();
        }
        return this.containerRuntimeOptions;
    }

    public List<URLListenerDescriptor> getURLListenerDescriptors() {
        if (this.urlListenerDescriptors == null) {
            return Collections.emptyList();
        }
        return this.urlListenerDescriptors;
    }

    public List<PortletURLGenerationListener> getURLGenerationListeners() {
        ArrayList<PortletURLGenerationListener> portletURLGenerationListeners = new ArrayList<PortletURLGenerationListener>();
        if (this.urlListenerDescriptors != null) {
            for (URLListenerDescriptor urlListenerDescriptor : this.urlListenerDescriptors) {
                portletURLGenerationListeners.add(urlListenerDescriptor.getListener());
            }
        }
        return portletURLGenerationListeners;
    }

    public Map<String, String[]> getContainerRuntimeOptions(PortletID portletID) {
        PortletDescriptor portletDescriptor = this.getPortletsDescriptor().getPortletDescriptor(portletID.getPortletName());
        Map<String, String[]> portletRuntimeOptions = portletDescriptor.getContainerRuntimeOptions();
        Map<String, String[]> runtimeOptions = this.getContainerRuntimeOptions();
        if (portletRuntimeOptions != null) {
            runtimeOptions.putAll(portletRuntimeOptions);
        }
        return runtimeOptions;
    }

    public String[] getContainerRuntimeOption(PortletID portletID, String optionName) {
        PortletDescriptor portletDescriptor = this.getPortletsDescriptor().getPortletDescriptor(portletID.getPortletName());
        String[] portletRuntimeOption = portletDescriptor.getContainerRuntimeOption(optionName);
        if (portletRuntimeOption == null) {
            portletRuntimeOption = this.containerRuntimeOptions.get(optionName);
        }
        return portletRuntimeOption;
    }

    public String getDefaultNamespace() {
        return this.defaultNameSpace;
    }

    protected void setURLPatterns(List<String> servletURLPatterns) {
        this.servletURLPatterns = servletURLPatterns;
    }

    public List<String> getServletURLPatterns() {
        return this.servletURLPatterns;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletAppDescriptor [");
        sb.append(" portlet app descriptions [");
        Iterator<String> iterator0 = this.descriptions.iterator();
        while (iterator0.hasNext()) {
            sb.append(iterator0.next());
        }
        sb.append(" ]");
        sb.append(" portlet app display names [");
        Iterator<String> iterator2 = this.displayNames.iterator();
        while (iterator2.hasNext()) {
            sb.append(iterator2.next());
        }
        sb.append(" ]");
        sb.append(this.getPortletsDescriptor().toString());
        for (UserAttributeDescriptor userAttrDescriptor : this.userAttributeDescriptors) {
            sb.append(userAttrDescriptor.toString());
            sb.append("\n");
        }
        sb.append("]");
        sb.append(" security constraint description [");
        if (this.secConstraintDescriptor != null) {
            sb.append(this.secConstraintDescriptor.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    private Map<PortletID, List<EventHolder>> getEventMap(Map<PortletID, List<QName>> portletEvents) {
        HashMap<PortletID, List<EventHolder>> eventMap = new HashMap<PortletID, List<EventHolder>>(portletEvents.size());
        Set<Map.Entry<PortletID, List<QName>>> entries = portletEvents.entrySet();
        for (Map.Entry<PortletID, List<QName>> mapEntry : entries) {
            List<QName> publishingProcessingEvents = mapEntry.getValue();
            ArrayList<EventHolder> eventHolders = new ArrayList<EventHolder>(publishingProcessingEvents.size());
            for (EventDescriptor eventDescriptor : this.eventDescriptors) {
                if (!this.doesEventDefinitionContainSupportedEvent(eventDescriptor.getQName(), publishingProcessingEvents)) continue;
                eventHolders.add(eventDescriptor.getEventHolder());
            }
            eventMap.put(mapEntry.getKey(), eventHolders);
        }
        return eventMap;
    }

    private boolean doesEventDefinitionContainSupportedEvent(QName eventDescriptorQName, List<QName> supportedEvents) {
        String eventDefinitionName = eventDescriptorQName.getLocalPart();
        if (eventDefinitionName.endsWith(".")) {
            return false;
        }
        for (QName supportedEvent : supportedEvents) {
            String supportedEventName = supportedEvent.getLocalPart();
            if (!eventDescriptorQName.getNamespaceURI().equals(supportedEvent.getNamespaceURI())) continue;
            if (supportedEventName.endsWith("..") && eventDefinitionName.indexOf(".") != -1) {
                int index = supportedEventName.indexOf("..");
                String partialEventName = supportedEventName.substring(0, index);
                if (!eventDefinitionName.startsWith(partialEventName)) continue;
                return true;
            }
            if (supportedEventName.endsWith(".") && eventDefinitionName.indexOf(".") != -1) {
                int index;
                String partialEventName;
                StringTokenizer tokens = new StringTokenizer(supportedEventName, ".");
                StringTokenizer tokens1 = new StringTokenizer(eventDefinitionName, ".");
                if (tokens1.countTokens() != tokens.countTokens() + 1 || !eventDefinitionName.startsWith(partialEventName = supportedEventName.substring(0, index = supportedEventName.lastIndexOf(".")))) continue;
                return true;
            }
            if (!eventDefinitionName.equals(supportedEventName)) continue;
            return true;
        }
        return false;
    }

    public String getVersion() {
        return this.version;
    }
}

