/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.util.pool;

import com.sun.portal.portletcontainer.appengine.util.concurrent.LockWithMemory;
import com.sun.portal.portletcontainer.appengine.util.pool.PartitionObject;
import com.sun.portal.portletcontainer.appengine.util.pool.ThreadPool;

public class ReusableThread
implements Runnable,
PartitionObject {
    private ThreadPool ownerPool;
    private Thread thread;
    private boolean running = true;
    private LockWithMemory begin = new LockWithMemory();
    private LockWithMemory end = new LockWithMemory();
    private Runnable runnable = null;
    private boolean executing = false;
    private int partition;
    private boolean reuse = true;

    public ReusableThread() {
        this(null);
    }

    ReusableThread(ThreadPool ownerPool) {
        this.ownerPool = ownerPool;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    void setReuseThread(boolean b) {
        this.reuse = b;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public int getPartition() {
        return this.partition;
    }

    void setRunnable(Runnable runnable) {
        this.runnable = runnable;
        this.executing = false;
    }

    public void start() {
        this.begin.signal();
        this.executing = true;
    }

    public void join() {
        this.join(0L, 0);
    }

    public void join(long timeout) {
        this.join(timeout, 0);
    }

    public void join(long timeout, int nanos) {
        if (this.runnable != null) {
            this.end.waitFor(timeout, nanos);
        }
    }

    public boolean isAlive() {
        return this.executing;
    }

    void finish() {
        this.running = false;
        this.begin.signal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.running) {
                try {
                    this.begin.waitFor();
                    if (!this.running) continue;
                    try {
                        if (this.runnable != null) {
                            this.runnable.run();
                        }
                    }
                    catch (Throwable ex1) {
                        System.out.println("ReusableThread.run(), ex1: " + ex1);
                    }
                    this.running = this.reuse;
                    this.end.signal();
                    this.executing = false;
                    if (this.ownerPool == null) continue;
                    this.ownerPool.releaseThread(this);
                }
                catch (Exception ex2) {
                    System.out.println("ReusableThread.run(), ex2: " + ex2);
                }
            }
            return;
        }
        catch (Exception ex3) {
            System.out.println("ReusableThread.run(), ex3: " + ex3);
        }
    }
}

