/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.appengine.LifecycleManager;
import com.sun.portal.portletcontainer.appengine.LifecycleManagerException;
import com.sun.portal.portletcontainer.appengine.PortletAppEngineUtils;
import com.sun.portal.portletcontainer.appengine.filter.FilterChainFactory;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorReader;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletPreferencesDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletsDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortalContextImpl;
import com.sun.portal.portletcontainer.portlet.impl.PortletConfigImpl;
import com.sun.portal.portletcontainer.portlet.impl.PortletContextImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.portlet.PortalContext;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PreferencesValidator;
import javax.portlet.UnavailableException;
import javax.portlet.filter.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleManagerImpl
implements LifecycleManager {
    private PortletAppDescriptor portletAppDescriptor;
    private Map<String, Object> portletExtensionDescriptors;
    private PortletContext portletContext;
    private Map<String, Portlet> portlets = new HashMap<String, Portlet>();
    private Map<String, PortletConfig> portletConfigs = new HashMap<String, PortletConfig>();
    private Map<String, PreferencesValidator> validators = new HashMap<String, PreferencesValidator>();
    private PortalContext portalContext;
    private FilterChainFactory filterChainFactory = null;
    private static Logger logger = ContainerLogger.getLogger(LifecycleManagerImpl.class, (String)"PAELogMessages");

    public LifecycleManagerImpl(ServletConfig config) {
        ServletContext context = config.getServletContext();
        InputStream portletXmlStream = context.getResourceAsStream("/WEB-INF/portlet.xml");
        InputStream webXmlStream = context.getResourceAsStream("/WEB-INF/web.xml");
        this.portletAppDescriptor = this.initPortletAppDescriptor(context, portletXmlStream, webXmlStream);
        try {
            portletXmlStream.close();
            webXmlStream.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.portletExtensionDescriptors = this.initPortletExtensionDescriptor(context);
        this.portalContext = this.initPortalContext();
        if (this.portletAppDescriptor != null) {
            this.portletContext = this.initPortletContext(context);
            this.portletContext.setAttribute("javax.portlet.portletc.servletConfig", (Object)config);
            this.createPortlets();
            this.filterChainFactory = new FilterChainFactory(this.portletAppDescriptor, this.portletContext);
        }
    }

    private PortletContext initPortletContext(ServletContext context) {
        return new PortletContextImpl(context, this.portletAppDescriptor);
    }

    private PortalContext initPortalContext() {
        return new PortalContextImpl();
    }

    private PortletAppDescriptor initPortletAppDescriptor(ServletContext context, InputStream portletXmlStream, InputStream webXmlStream) {
        String portletAppName = PortletAppEngineUtils.getPortletAppName(context);
        logger.log(Level.INFO, "PSPL_PAECSPPAI0015", portletAppName);
        DeploymentDescriptorReader reader = new DeploymentDescriptorReader(context);
        try {
            this.portletAppDescriptor = reader.getPortletAppDescriptor(portletAppName, portletXmlStream, false);
            reader.readWebAppDescriptor(this.portletAppDescriptor, webXmlStream);
        }
        catch (DeploymentDescriptorException de) {
            // empty catch block
        }
        return this.portletAppDescriptor;
    }

    private Map<String, Object> initPortletExtensionDescriptor(ServletContext context) {
        DeploymentDescriptorReader reader = new DeploymentDescriptorReader(context);
        try {
            this.portletExtensionDescriptors = reader.getPortletExtensionDescriptors(context);
        }
        catch (DeploymentDescriptorException deploymentDescriptorException) {
            // empty catch block
        }
        return this.portletExtensionDescriptors;
    }

    @Override
    public PortletAppDescriptor getPortletAppDescriptor() {
        return this.portletAppDescriptor;
    }

    @Override
    public Object getPortletExtensionDescriptor(String vendorPortletXMLName) {
        return this.portletExtensionDescriptors.get(vendorPortletXMLName);
    }

    @Override
    public Portlet getPortlet(String portletName) throws LifecycleManagerException {
        Portlet p = this.portlets.get(portletName);
        if (p == null) {
            logger.log(Level.SEVERE, "PSPL_PAECSPPAI0009", portletName);
            throw new LifecycleManagerException("Cannot get the portlet:" + portletName);
        }
        return p;
    }

    @Override
    public PreferencesValidator getPreferencesValidator(String portletName) {
        return this.validators.get(portletName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePortlet(String portletName) {
        Portlet p = this.portlets.get(portletName);
        if (p != null) {
            Map<String, Portlet> map = this.portlets;
            synchronized (map) {
                this.portlets.put(portletName, null);
            }
        }
    }

    @Override
    public PortletConfig getPortletConfig(String portletName) {
        PortletConfig config = this.portletConfigs.get(portletName);
        if (config == null) {
            logger.log(Level.WARNING, "PSPL_PAECSPPAI0014", portletName);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePortletConfig(String portletName) {
        PortletConfig config = this.portletConfigs.get(portletName);
        if (config != null) {
            Map<String, PortletConfig> map = this.portletConfigs;
            synchronized (map) {
                this.portletConfigs.put(portletName, null);
            }
        }
    }

    @Override
    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    @Override
    public PortalContext getPortalContext() {
        return this.portalContext;
    }

    public void destroy() {
        this.portletAppDescriptor = null;
        this.portletContext = null;
        for (String portletName : this.portlets.keySet()) {
            Portlet p = this.portlets.get(portletName);
            try {
                p.destroy();
            }
            catch (RuntimeException re) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.log(Level.INFO, "PSPL_PAECSPPAI0010", new Object[]{portletName, re.getMessage()});
            }
        }
        this.portlets.clear();
        this.portletConfigs.clear();
        this.validators.clear();
        this.filterChainFactory.clear();
    }

    private Portlet createPortlet(String portletName, PortletDescriptor portletDescriptor) throws LifecycleManagerException {
        Portlet portlet;
        String portletClassName = portletDescriptor.getClassName();
        PreferencesValidator validator = null;
        if (portletClassName == null) {
            throw new LifecycleManagerException("LifecycleManagerImpl.getPortlet(), the portlet class name is not defined for portlet: " + portletName);
        }
        logger.log(Level.FINE, "PSPL_PAECSPPAI0011", portletClassName);
        try {
            Class<?> portletClass = Thread.currentThread().getContextClassLoader().loadClass(portletClassName);
            portlet = (Portlet)portletClass.newInstance();
            PortletPreferencesDescriptor pPrefDescriptor = portletDescriptor.getPortletPreferencesDescriptor();
            if (pPrefDescriptor != null && (validator = this.instantiatePreferencesValidator(pPrefDescriptor.getPreferencesValidatorName())) != null) {
                this.validators.put(portletName, validator);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new LifecycleManagerException(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new LifecycleManagerException(iae);
        }
        catch (ClassCastException cce) {
            throw new LifecycleManagerException(cce);
        }
        catch (InstantiationException ie) {
            throw new LifecycleManagerException(ie);
        }
        return portlet;
    }

    private void createPortlets() {
        PortletsDescriptor portletsDescriptor = null;
        if (this.portletAppDescriptor != null) {
            portletsDescriptor = this.portletAppDescriptor.getPortletsDescriptor();
        }
        if (portletsDescriptor != null) {
            List<String> portletNames = portletsDescriptor.getPortletNames();
            for (String portletName : portletNames) {
                PortletDescriptor portletDescriptor = portletsDescriptor.getPortletDescriptor(portletName);
                if (portletDescriptor == null) continue;
                PortletConfigImpl config = new PortletConfigImpl(this.portletAppDescriptor, portletDescriptor, portletName, this.portletContext);
                try {
                    Portlet p = this.createPortlet(portletName, portletDescriptor);
                    p.init((PortletConfig)config);
                    this.portlets.put(portletName, p);
                    this.portletConfigs.put(portletName, config);
                    logger.log(Level.INFO, "PSPL_PAECSPPAI0012", portletName);
                }
                catch (LifecycleManagerException lcme) {
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logger.log(this.getLogRecord(portletName, lcme));
                }
                catch (UnavailableException ue) {
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logger.log(this.getLogRecord(portletName, ue));
                }
                catch (PortletException pe) {
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logger.log(this.getLogRecord(portletName, pe));
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logger.log(this.getLogRecord(portletName, t));
                }
            }
        }
    }

    private PreferencesValidator instantiatePreferencesValidator(String validatorName) {
        PreferencesValidator validator = null;
        if (validatorName != null) {
            try {
                Class<?> validatorClass = Thread.currentThread().getContextClassLoader().loadClass(validatorName);
                validator = (PreferencesValidator)validatorClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (ClassCastException cce) {
            }
            catch (InstantiationException ie) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return validator;
    }

    @Override
    public FilterChain getFilterChain(String portletName, Portlet p, String lifeCycle) {
        return this.filterChainFactory.getPortletFilterChain(portletName, p, lifeCycle);
    }

    private LogRecord getLogRecord(String parameter, Throwable cause) {
        LogRecord logRecord = new LogRecord(Level.SEVERE, "PSPL_PAECSPPAI0013");
        logRecord.setParameters(new String[]{parameter});
        logRecord.setThrown(cause);
        logRecord.setLoggerName(logger.getName());
        return logRecord;
    }
}

