/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.PortletID;
import com.sun.portal.container.service.PortletDescriptorHolder;
import com.sun.portal.container.service.PortletDescriptorHolderFactory;
import com.sun.portal.portletcontainer.appengine.LifecycleManager;
import com.sun.portal.portletcontainer.appengine.LifecycleManagerException;
import com.sun.portal.portletcontainer.appengine.PortletAppEngineUtils;
import com.sun.portal.portletcontainer.appengine.RequestResponseFactory;
import com.sun.portal.portletcontainer.appengine.StringServletOutputStream;
import com.sun.portal.portletcontainer.appengine.impl.LifecycleManagerImpl;
import com.sun.portal.portletcontainer.appengine.impl.RequestResponseFactoryImpl;
import com.sun.portal.portletcontainer.common.PortletContainerActionRequest;
import com.sun.portal.portletcontainer.common.PortletContainerActionResponse;
import com.sun.portal.portletcontainer.common.PortletContainerCacheControl;
import com.sun.portal.portletcontainer.common.PortletContainerErrorCode;
import com.sun.portal.portletcontainer.common.PortletContainerEventRequest;
import com.sun.portal.portletcontainer.common.PortletContainerEventResponse;
import com.sun.portal.portletcontainer.common.PortletContainerRenderRequest;
import com.sun.portal.portletcontainer.common.PortletContainerRenderResponse;
import com.sun.portal.portletcontainer.common.PortletContainerRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResourceRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResourceResponse;
import com.sun.portal.portletcontainer.common.PortletContainerResponse;
import com.sun.portal.portletcontainer.common.PortletContainerUtil;
import com.sun.portal.portletcontainer.common.PreferencesValidatorSetter;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentExtensionDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.EventDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.SecurityConstraintDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortletsResources;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.StateAwareResponse;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.portlet.filter.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletAppEngineServlet
extends HttpServlet {
    public static final String CONFIDENTIAL = "CONFIDENTIAL";
    public static final String INTEGRAL = "INTEGRAL";
    private LifecycleManager lifecycleManager;
    private RequestResponseFactory requestResponseFactory;
    private PortletAppDescriptor portletAppDescriptor;
    private ServletContext context;
    private PortletsResources portletsResources;
    private static Logger logger = ContainerLogger.getLogger(PortletAppEngineServlet.class, (String)"PAELogMessages");
    private static final String CLIENT_EVENT_OBJECT_VALUE_TYPE = "com.sun.portlet.ClientEvent";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
        this.lifecycleManager = new LifecycleManagerImpl(config);
        this.context.setAttribute("lifecycle_manager", (Object)this.lifecycleManager);
        this.requestResponseFactory = new RequestResponseFactoryImpl(this.context);
        this.context.setAttribute("request_response_factory", (Object)this.requestResponseFactory);
        this.portletAppDescriptor = this.lifecycleManager.getPortletAppDescriptor();
        try {
            PortletDescriptorHolderFactory.getPortletDescriptorHolder().load((Object)this.portletAppDescriptor);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        this.portletsResources = new PortletsResources(this.portletAppDescriptor);
        this.context.setAttribute("com.sun.portal.portletcontainer.portlet_resources", this.portletsResources.getPortletResourceMap());
        this.context.setAttribute("com.sun.portal.portletcontainer.portlet_metadata_resources", this.portletsResources.getPortletMetadataResourceMap());
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringWriter stringWriter = new StringWriter(1024);
        StringServletOutputStream outputStream = new StringServletOutputStream(new ByteArrayOutputStream(1024));
        ActionRequest actionRequest = null;
        RenderRequest renderRequest = null;
        ActionResponse actionResponse = null;
        RenderResponse renderResponse = null;
        EventRequest eventRequest = null;
        EventResponse eventResponse = null;
        ResourceRequest resourceRequest = null;
        ResourceResponse resourceResponse = null;
        PortletContainerRequest pcRequest = (PortletContainerRequest)request.getAttribute("com.sun.portal.portletcontainer.portlet_container_request");
        PortletContainerResponse pcResponse = (PortletContainerResponse)request.getAttribute("com.sun.portal.portletcontainer.portlet_container_response");
        String portletName = pcRequest.getPortletName();
        PortletMode portletMode = PortletAppEngineUtils.getPortletMode(pcRequest.getPortletWindowMode());
        WindowState windowState = PortletAppEngineUtils.getWindowState(pcRequest.getWindowState());
        List<String> actionList = pcRequest.getActions();
        String entityID = pcRequest.getEntityID().toString();
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer actionListBuffer = new StringBuffer();
            for (int j = 0; j < actionList.size(); ++j) {
                actionListBuffer.append(actionList.get(j));
                actionListBuffer.append(" | ");
            }
            logger.log(Level.FINEST, "PSPL_PAECSPPA0001", new Object[]{request.getContextPath(), entityID, portletName, portletMode, windowState, actionListBuffer});
        }
        if (this.checkSecurityConstraint(request, portletName)) {
            PortletDescriptor portletDescriptor = this.getPortletDescriptor(portletName);
            PreferencesValidator validator = this.lifecycleManager.getPreferencesValidator(portletName);
            Portlet p = null;
            try {
                p = this.lifecycleManager.getPortlet(portletName);
                PortletConfig portletConfig = this.lifecycleManager.getPortletConfig(portletName);
                request.setAttribute("javax.portlet.config", (Object)portletConfig);
                logger.log(Level.FINEST, "PSPL_PAECSPPA0002", portletName);
                boolean stop = false;
                for (int i = 0; i < actionList.size() && !stop; ++i) {
                    FilterChain filterChain;
                    Queue eventQueue;
                    String action = actionList.get(i);
                    this.setSharedSessionAttributeDescriptors(pcRequest);
                    if (action.equals("ACTION")) {
                        Map<String, String[]> publicRenderParams;
                        PortletContainerActionRequest pcActionRequest = (PortletContainerActionRequest)pcRequest;
                        PortletContainerActionResponse pcActionResponse = (PortletContainerActionResponse)pcResponse;
                        actionRequest = this.requestResponseFactory.getActionRequest(request, response, pcActionRequest, pcActionResponse, this.lifecycleManager.getPortletContext(), this.lifecycleManager.getPortalContext(), portletDescriptor);
                        actionResponse = this.requestResponseFactory.getActionResponse(request, response, pcActionRequest, pcActionResponse, actionRequest, this.portletAppDescriptor, portletDescriptor);
                        this.setLifecycle((PortletRequest)actionRequest, "ACTION_PHASE");
                        this.setValidator((PortletRequest)actionRequest, validator, false);
                        this.setRequestResponseAttributes(request, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
                        FilterChain filterChain2 = this.lifecycleManager.getFilterChain(portletName, p, "ACTION_PHASE");
                        if (filterChain2 != null) {
                            filterChain2.doFilter(actionRequest, actionResponse);
                        } else {
                            p.processAction(actionRequest, actionResponse);
                        }
                        if (this.isActionScopedRequestAttributeEnabled(portletDescriptor.getPortletID())) {
                            String actionScopeIDValue = this.generateActionScopeID(portletDescriptor);
                            HashMap<String, String[]> map = new HashMap<String, String[]>(actionResponse.getRenderParameterMap());
                            map.put("javax.portlet.as", new String[]{actionScopeIDValue});
                            actionResponse.setRenderParameters(map);
                            this.setScopedAttributes(actionScopeIDValue, portletDescriptor.getPortletID(), pcActionRequest, (PortletRequest)actionRequest);
                        }
                        if (pcActionResponse.getRedirectURL() != null) {
                            stop = true;
                        }
                        if ((publicRenderParams = this.getUpdatedPublicRenderParameters(portletConfig, (StateAwareResponse)actionResponse)).size() > 0) {
                            pcActionResponse.setPublicRenderParameters(publicRenderParams);
                        }
                        this.setValidator((PortletRequest)actionRequest, validator, true);
                        pcActionResponse.setNewChannelMode(pcActionResponse.getChannelMode());
                        pcActionResponse.setNewChannelState(pcActionResponse.getChannelState());
                        eventQueue = (Queue)actionRequest.getAttribute("com.sun.portal.portletcontainer.events");
                        if (eventQueue != null && eventQueue.size() > 0) {
                            pcActionResponse.setEventQueue(eventQueue);
                        }
                        actionRequest.removeAttribute("com.sun.portal.portletcontainer.events");
                        continue;
                    }
                    if (action.equals("EVENT")) {
                        if (p instanceof EventPortlet) {
                            Map<String, String[]> publicRenderParams;
                            EventPortlet eventPortlet = (EventPortlet)p;
                            PortletContainerEventRequest pcEventRequest = (PortletContainerEventRequest)pcRequest;
                            PortletContainerEventResponse pcEventResponse = (PortletContainerEventResponse)pcResponse;
                            eventRequest = this.requestResponseFactory.getEventRequest(request, response, pcEventRequest, pcEventResponse, this.lifecycleManager.getPortletContext(), this.lifecycleManager.getPortalContext(), portletDescriptor);
                            eventResponse = this.requestResponseFactory.getEventResponse(request, response, pcEventRequest, pcEventResponse, eventRequest, this.portletAppDescriptor, portletDescriptor);
                            this.setLifecycle((PortletRequest)eventRequest, "EVENT_PHASE");
                            this.setValidator((PortletRequest)eventRequest, validator, false);
                            this.setRequestResponseAttributes(request, (PortletRequest)eventRequest, (PortletResponse)eventResponse);
                            filterChain = this.lifecycleManager.getFilterChain(portletName, p, "EVENT_PHASE");
                            if (filterChain != null) {
                                filterChain.doFilter(eventRequest, eventResponse);
                            } else {
                                eventPortlet.processEvent(eventRequest, eventResponse);
                            }
                            eventQueue = (Queue)eventRequest.getAttribute("com.sun.portal.portletcontainer.events");
                            if (eventQueue != null && eventQueue.size() > 0) {
                                pcEventResponse.setEventQueue(eventQueue);
                            }
                            eventRequest.removeAttribute("com.sun.portal.portletcontainer.events");
                            if (this.isActionScopedRequestAttributeEnabled(portletDescriptor.getPortletID())) {
                                String actionScopeIDValue = eventRequest.getParameter("javax.portlet.as");
                                if (actionScopeIDValue == null) {
                                    actionScopeIDValue = this.generateActionScopeID(portletDescriptor);
                                    HashMap<String, String[]> map = new HashMap<String, String[]>(eventResponse.getRenderParameterMap());
                                    map.put("javax.portlet.as", new String[]{actionScopeIDValue});
                                    eventResponse.setRenderParameters(map);
                                }
                                this.setScopedAttributes(actionScopeIDValue, portletDescriptor.getPortletID(), pcEventRequest, (PortletRequest)eventRequest);
                            }
                            if ((publicRenderParams = this.getUpdatedPublicRenderParameters(portletConfig, (StateAwareResponse)eventResponse)).size() > 0) {
                                pcEventResponse.setPublicRenderParameters(publicRenderParams);
                            }
                            pcEventResponse.setNewChannelMode(pcEventResponse.getChannelMode());
                            pcEventResponse.setNewChannelState(pcEventResponse.getChannelState());
                            continue;
                        }
                        logger.log(Level.WARNING, "PSPL_PAECSPPA0031", portletName);
                        continue;
                    }
                    if (action.equals("RENDER")) {
                        PortletContainerRenderRequest pcRenderRequest = (PortletContainerRenderRequest)pcRequest;
                        PortletContainerRenderResponse pcRenderResponse = (PortletContainerRenderResponse)pcResponse;
                        this.setCacheParams(pcRenderResponse.getCacheControl(), portletDescriptor, pcRenderRequest.getETag());
                        renderRequest = this.requestResponseFactory.getRenderRequest(request, response, pcRenderRequest, pcRenderResponse, this.lifecycleManager.getPortletContext(), this.lifecycleManager.getPortalContext(), portletDescriptor);
                        renderResponse = this.requestResponseFactory.getRenderResponse(request, response, pcRenderRequest, pcRenderResponse, renderRequest, this.portletAppDescriptor, portletDescriptor, stringWriter, outputStream);
                        this.setLifecycle((PortletRequest)renderRequest, "RENDER_PHASE");
                        this.setValidator((PortletRequest)renderRequest, validator, false);
                        this.setRequestResponseAttributes(request, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
                        String title = this.getPortletTitle(request, pcRenderRequest, entityID, portletName);
                        renderRequest.setAttribute("com.sun.portal.portletcontainer.portlet.title", (Object)title);
                        String genericPortletTitle = this.getGenericPortletTitle(portletConfig, renderRequest);
                        if (genericPortletTitle != null) {
                            renderRequest.setAttribute("com.sun.portal.portletcontainer.portlet.generic.title", (Object)genericPortletTitle);
                        }
                        this.handlePortalQueryParameters(portletName, pcRenderRequest);
                        FilterChain filterChain3 = this.lifecycleManager.getFilterChain(portletName, p, "RENDER_PHASE");
                        if (filterChain3 != null) {
                            filterChain3.doFilter(renderRequest, renderResponse);
                        } else {
                            p.render(renderRequest, renderResponse);
                        }
                        StringBuffer clientEventDataBuffer = this.getClientEventData(portletDescriptor, pcRenderRequest);
                        StringBuffer writerOuput = stringWriter.getBuffer();
                        String streamOutput = outputStream.toString(response.getCharacterEncoding());
                        StringBuffer markup = writerOuput.length() > 0 ? writerOuput : (streamOutput.length() > 0 ? new StringBuffer(streamOutput) : new StringBuffer(""));
                        if (clientEventDataBuffer.length() != 0) {
                            markup.insert(0, clientEventDataBuffer);
                        }
                        pcRenderResponse.setMarkup(markup);
                        this.setValidator((PortletRequest)renderRequest, validator, true);
                        continue;
                    }
                    if (!action.equals("RESOURCE")) continue;
                    if (p instanceof ResourceServingPortlet) {
                        ResourceServingPortlet resourceServingPortlet = (ResourceServingPortlet)p;
                        PortletContainerResourceRequest pcResourceRequest = (PortletContainerResourceRequest)pcRequest;
                        PortletContainerResourceResponse pcResourceResponse = (PortletContainerResourceResponse)pcResponse;
                        this.setCacheParams(pcResourceResponse.getCacheControl(), portletDescriptor, pcResourceRequest.getETag());
                        resourceRequest = this.requestResponseFactory.getResourceRequest(request, pcResourceResponse.getHttpServletResponse(), pcResourceRequest, pcResourceResponse, this.lifecycleManager.getPortletContext(), this.lifecycleManager.getPortalContext(), portletDescriptor);
                        resourceResponse = this.requestResponseFactory.getResourceResponse(pcResourceRequest.getHttpServletRequest(), pcResourceResponse.getHttpServletResponse(), pcResourceRequest, pcResourceResponse, resourceRequest, this.portletAppDescriptor, portletDescriptor, stringWriter, outputStream);
                        this.setLifecycle((PortletRequest)resourceRequest, "RESOURCE_PHASE");
                        this.setValidator((PortletRequest)resourceRequest, validator, false);
                        this.setRequestResponseAttributes(request, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
                        filterChain = this.lifecycleManager.getFilterChain(portletName, p, "RESOURCE_PHASE");
                        if (filterChain != null) {
                            filterChain.doFilter(resourceRequest, resourceResponse);
                        } else {
                            resourceServingPortlet.serveResource(resourceRequest, resourceResponse);
                        }
                        StringBuffer buff = stringWriter.getBuffer();
                        byte[] bytes = outputStream.toByteArray();
                        if (buff.length() > 0) {
                            pcResourceResponse.setContentAsBuffer(buff);
                            continue;
                        }
                        if (bytes != null && bytes.length > 0) {
                            pcResourceResponse.setContentAsBytes(bytes);
                            continue;
                        }
                        pcResourceResponse.setContentAsBuffer(new StringBuffer(""));
                        continue;
                    }
                    logger.log(Level.WARNING, "PSPL_PAECSPPA0030", portletName);
                }
            }
            catch (UnavailableException ue) {
                if (p != null) {
                    p.destroy();
                    this.lifecycleManager.removePortlet(portletName);
                    this.lifecycleManager.removePortletConfig(portletName);
                }
                pcResponse.setErrorCode(PortletContainerErrorCode.PORTLET_UNAVAILABLE);
                pcResponse.setException((Exception)((Object)ue));
                logger.log(Level.WARNING, "PSPL_PAECSPPA0004", ue);
            }
            catch (PortletSecurityException pse) {
                pcResponse.setErrorCode(PortletContainerErrorCode.SECURITY_VIOLATION);
                pcResponse.setException((Exception)((Object)pse));
                logger.log(Level.WARNING, "PSPL_PAECSPPA0009", pse);
            }
            catch (PortletException pe) {
                Throwable cause = pe.getCause();
                if (pe instanceof PortletModeException || cause instanceof PortletModeException) {
                    pcResponse.setErrorCode(PortletContainerErrorCode.UNSUPPORTED_MODE);
                    pcResponse.setException((Exception)((Object)pe));
                    logger.log(Level.WARNING, "PSPL_PAECSPPA0010", pe);
                } else if (pe instanceof ReadOnlyException || cause instanceof ReadOnlyException) {
                    pcResponse.setErrorCode(PortletContainerErrorCode.READONLY_ERROR);
                    pcResponse.setException((Exception)((Object)pe));
                    logger.log(Level.WARNING, "PSPL_PAECSPPA0011", pe);
                } else if (pe instanceof WindowStateException || cause instanceof WindowStateException) {
                    pcResponse.setErrorCode(PortletContainerErrorCode.UNSUPPORTED_STATE);
                    pcResponse.setException((Exception)((Object)pe));
                    logger.log(Level.WARNING, "PSPL_PAECSPPA0012", pe);
                } else if (cause instanceof ServletException) {
                    pcResponse.setErrorCode(PortletContainerErrorCode.MISC_ERROR);
                    pcResponse.setException((Exception)((Object)pe));
                    logger.log(Level.WARNING, "PSPL_PAECSPPA0036", cause);
                } else {
                    pcResponse.setErrorCode(PortletContainerErrorCode.MISC_ERROR);
                    pcResponse.setException((Exception)((Object)pe));
                    logger.log(Level.WARNING, "PSPL_PAECSPPA0013", pe);
                }
            }
            catch (IOException ie) {
                pcResponse.setErrorCode(PortletContainerErrorCode.MISC_ERROR);
                pcResponse.setException(ie);
                logger.log(Level.WARNING, "PSPL_PAECSPPA0014", ie);
            }
            catch (LifecycleManagerException lme) {
                pcResponse.setErrorCode(PortletContainerErrorCode.PORTLET_UNAVAILABLE);
                pcResponse.setException(lme);
            }
            catch (RuntimeException re) {
                pcResponse.setErrorCode(PortletContainerErrorCode.MISC_ERROR);
                pcResponse.setException(re);
                logger.log(Level.WARNING, "PSPL_PAECSPPA0015", re);
            }
            if (actionRequest != null) {
                this.requestResponseFactory.releaseActionRequest(actionRequest);
            }
            if (renderRequest != null) {
                this.requestResponseFactory.releaseRenderRequest(renderRequest);
            }
            if (eventRequest != null) {
                this.requestResponseFactory.releaseEventRequest(eventRequest);
            }
            if (resourceRequest != null) {
                this.requestResponseFactory.releaseResourceRequest(resourceRequest);
            }
            if (actionResponse != null) {
                this.requestResponseFactory.releaseActionResponse(actionResponse);
            }
            if (renderResponse != null) {
                this.requestResponseFactory.releaseRenderResponse(renderResponse);
            }
            if (eventResponse != null) {
                this.requestResponseFactory.releaseEventResponse(eventResponse);
            }
            if (resourceResponse != null) {
                this.requestResponseFactory.releaseResourceResponse(resourceResponse);
            }
        } else {
            pcResponse.setErrorCode(PortletContainerErrorCode.SECURITY_VIOLATION);
            logger.log(Level.WARNING, "PSPL_PAECSPPA0005");
        }
    }

    private StringBuffer getClientEventData(PortletDescriptor portletDescriptor, PortletContainerRenderRequest pcRenderRequest) {
        StringBuffer clientEventDataBuffer = new StringBuffer();
        List<QName> supportedPublishingEvents = portletDescriptor.getSupportedPublishingEvents();
        HashMap publishingEventQnameProcessingEventNamespaces = null;
        for (QName publishingEventQname : supportedPublishingEvents) {
            EventDescriptor eventDescriptor = this.portletAppDescriptor.getEventDescriptor(publishingEventQname);
            if (eventDescriptor == null || !CLIENT_EVENT_OBJECT_VALUE_TYPE.equals(eventDescriptor.getValueType())) continue;
            if (publishingEventQnameProcessingEventNamespaces == null) {
                publishingEventQnameProcessingEventNamespaces = new HashMap();
            }
            List supportedProcessingPortlets = null;
            try {
                PortletDescriptorHolder portletDescriptorHolder = PortletDescriptorHolderFactory.getPortletDescriptorHolder();
                supportedProcessingPortlets = portletDescriptorHolder.getEventProcessingPortlets(publishingEventQname);
                ArrayList<String> processEventNamespaces = new ArrayList<String>();
                for (PortletID supportedProcessingPortlet : supportedProcessingPortlets) {
                    processEventNamespaces.add(pcRenderRequest.getNamespace(supportedProcessingPortlet));
                }
                if (processEventNamespaces.isEmpty()) continue;
                publishingEventQnameProcessingEventNamespaces.put(publishingEventQname, processEventNamespaces);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "PSPL_PAECSPPA0007", ex);
            }
        }
        if (publishingEventQnameProcessingEventNamespaces != null) {
            clientEventDataBuffer.append(this.getClientEventDataBuffer(pcRenderRequest.getNamespace(), publishingEventQnameProcessingEventNamespaces));
        }
        return clientEventDataBuffer;
    }

    private StringBuffer getClientEventDataBuffer(String publishingEventNamespace, Map<QName, List<String>> publishingEventQnameProcessingEventNamespaces) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<script type=\"text/javascript\">");
        buffer.append(publishingEventNamespace).append("EventQueue = {");
        buffer.append("setEvent : function(qname, values) {");
        buffer.append("var eventQueue = {");
        int i = 0;
        Set<Map.Entry<QName, List<String>>> entries = publishingEventQnameProcessingEventNamespaces.entrySet();
        int entrySize = entries.size();
        for (Map.Entry<QName, List<String>> mapEntry : entries) {
            ArrayList<String> processEventNamespaces = new ArrayList<String>();
            for (String processEventNamespace : mapEntry.getValue()) {
                if (processEventNamespace == null) continue;
                processEventNamespaces.add(processEventNamespace);
            }
            QName qname = mapEntry.getKey();
            int size = processEventNamespaces.size();
            int j = 0;
            buffer.append("\"").append(qname.getNamespaceURI()).append("|").append(qname.getLocalPart()).append("\"");
            buffer.append(":").append("[");
            for (String processEventNamespace : processEventNamespaces) {
                buffer.append(processEventNamespace).append("PortletObj");
                if (++j >= size) continue;
                buffer.append(",");
            }
            buffer.append("]");
            if (++i >= entrySize) continue;
            buffer.append(",");
        }
        buffer.append("};");
        buffer.append("for(var e in eventQueue){");
        buffer.append("var qnameArray = new Array(); qnameArray = e.split('|');");
        buffer.append("var qnameUri, qnameLocalPart;");
        buffer.append("if(typeof(qname.uri) == 'undefined') { qnameUri = \"\"; }");
        buffer.append("else { qnameUri = qname.uri; }");
        buffer.append("if(typeof(qname.name) == 'undefined') { qnameLocalPart = qname; }");
        buffer.append("else { qnameLocalPart = qname.name; }");
        buffer.append("if(qnameUri == qnameArray[0] && qnameLocalPart == qnameArray[1]){");
        buffer.append("for(i=0; i<eventQueue[e].length; i++){");
        buffer.append("eventQueue[e][i].processEvent(values);");
        buffer.append("}}}}};</script>");
        return buffer;
    }

    private PortletDescriptor getPortletDescriptor(String portletName) {
        PortletDescriptor portletDescriptor = null;
        if (this.portletAppDescriptor != null && this.portletAppDescriptor.getPortletsDescriptor() != null && (portletDescriptor = this.portletAppDescriptor.getPortletsDescriptor().getPortletDescriptor(portletName)) == null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "PSPL_PAECSPPA0003", portletName);
        }
        return portletDescriptor;
    }

    private void setLifecycle(PortletRequest portletRequest, String lifecycle) {
        portletRequest.setAttribute("javax.portlet.lifecycle_phase", (Object)lifecycle);
    }

    private void setRequestResponseAttributes(HttpServletRequest request, PortletRequest portletRequest, PortletResponse portletResponse) {
        request.setAttribute("javax.portlet.request", (Object)portletRequest);
        request.setAttribute("javax.portlet.response", (Object)portletResponse);
    }

    private void handlePortalQueryParameters(String portletName, PortletContainerRenderRequest pcRenderRequest) {
        List<String> portalQueryParameterNames;
        DeploymentExtensionDescriptor sunPortletDescriptor = PortletContainerUtil.getSunPortletDescriptor(this.lifecycleManager);
        if (sunPortletDescriptor != null && (portalQueryParameterNames = sunPortletDescriptor.getPortalQueryParameters(portletName)) != null && !portalQueryParameterNames.isEmpty()) {
            Map parameterMap = pcRenderRequest.getHttpServletRequest().getParameterMap();
            HashMap<String, String[]> queryParameterMap = new HashMap<String, String[]>();
            for (String name : portalQueryParameterNames) {
                if (!parameterMap.containsKey(name)) continue;
                queryParameterMap.put(name, (String[])parameterMap.get(name));
            }
            pcRenderRequest.setQueryParameters(queryParameterMap);
        }
    }

    private void setSharedSessionAttributeDescriptors(PortletContainerRequest pcRequest) {
        DeploymentExtensionDescriptor sunPortletDescriptor = PortletContainerUtil.getSunPortletDescriptor(this.lifecycleManager);
        if (sunPortletDescriptor != null) {
            pcRequest.setSharedSessionAttributeDescriptors(sunPortletDescriptor.getSharedSessionAttributeDescriptors());
        }
    }

    private void setValidator(PortletRequest pReq, PreferencesValidator validator, boolean cleanup) {
        if (pReq.getPreferences() instanceof PreferencesValidatorSetter) {
            PreferencesValidatorSetter setter = (PreferencesValidatorSetter)pReq.getPreferences();
            if (setter != null && cleanup) {
                setter.setPreferencesValidator(null);
            }
            if (setter != null && validator != null) {
                setter.setPreferencesValidator(validator);
            }
        }
    }

    private void setCacheParams(PortletContainerCacheControl pcCacheControl, PortletDescriptor portletDescriptor, String eTag) {
        int expiration = 0;
        if (portletDescriptor != null) {
            expiration = portletDescriptor.getCacheExpiration();
            String scope = portletDescriptor.getCachingScope();
            if (scope != null && scope.equals("public")) {
                pcCacheControl.setPublicScope(true);
            }
        }
        if (expiration == -999) {
            pcCacheControl.setExpirationTime(0);
        } else {
            pcCacheControl.setExpirationTime(expiration);
        }
        pcCacheControl.setETag(eTag);
    }

    private boolean checkSecurityConstraint(HttpServletRequest request, String portletName) {
        List<String> portlets;
        String transportGuaranteeType;
        boolean isValid = true;
        SecurityConstraintDescriptor secConsDescriptor = this.portletAppDescriptor.getSecurityConstraintDescriptor();
        if (secConsDescriptor != null && (CONFIDENTIAL.equals(transportGuaranteeType = secConsDescriptor.getTransportGuaranteeType()) || INTEGRAL.equals(transportGuaranteeType)) && (portlets = secConsDescriptor.getConstrainedPortlets()).contains(portletName) && !request.isSecure()) {
            isValid = false;
        }
        return isValid;
    }

    private String getGenericPortletTitle(PortletConfig portletConfig, RenderRequest renderRequest) {
        ResourceBundle bundle = portletConfig.getResourceBundle(renderRequest.getLocale());
        return this.getTitleFromRB(bundle, null);
    }

    private String getTitleFromPortletDescriptor(String portletName) {
        PortletDescriptor pd = this.getPortletDescriptor(portletName);
        String title = null;
        if (pd.getPortletInfoDescriptor() != null) {
            title = pd.getPortletInfoDescriptor().getTitle();
        }
        return title;
    }

    private String getTitleFromRB(ResourceBundle bundle, String portletName) {
        String title = null;
        if (bundle != null) {
            title = this.getStringFromBundle(bundle, "javax.portlet.title." + portletName);
            if (title == null) {
                title = this.getStringFromBundle(bundle, "javax.portlet.title");
            }
            if (title == null) {
                logger.log(Level.FINER, "PSPL_PAECSPPA0023", portletName);
            }
        }
        return title;
    }

    private String getTitleFromRB(String portletName, Locale locale) {
        Map<String, Map<String, ResourceBundle>> portletResourceMap = this.portletsResources.getPortletResourceMap();
        ResourceBundle bundle = PortletContainerUtil.getResourceBundle(portletResourceMap, portletName, locale);
        return this.getTitleFromRB(bundle, portletName);
    }

    private String getStringFromBundle(ResourceBundle bundle, String key) {
        String value = null;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            value = null;
        }
        return value;
    }

    private String getPortletTitle(HttpServletRequest request, PortletContainerRenderRequest pcRenderRequest, String entityID, String portletName) {
        Locale locale;
        Locale locale2;
        String rbTitle;
        String portletDescriptorTitle;
        String title = (String)request.getAttribute("com.sun.portal.portletcontainer.portlet.registry.title." + entityID);
        if (title != null && title.length() != 0 && (portletDescriptorTitle = this.getTitleFromPortletDescriptor(portletName)) != null && portletDescriptorTitle.equals(title) && (rbTitle = this.getTitleFromRB(portletName, locale2 = pcRenderRequest.getLocale())) != null) {
            title = rbTitle;
        }
        if (title == null || title.length() == 0) {
            logger.fine("PSPL_PAECSPPA0006");
            locale = pcRenderRequest.getLocale();
            title = this.getTitleFromRB(portletName, locale);
        }
        if (title == null || title.length() == 0) {
            locale = pcRenderRequest.getLocale();
            if (Locale.getDefault().equals(locale)) {
                logger.info("PSPL_PAECSPPA0008");
                title = this.getTitleFromPortletDescriptor(portletName);
            }
        }
        return title;
    }

    private String generateActionScopeID(PortletDescriptor portletDescriptor) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(portletDescriptor.getPortletID());
        buffer.append(Math.random());
        return buffer.toString();
    }

    private boolean isActionScopedRequestAttributeEnabled(PortletID portletID) {
        String[] containerRuntimeOption = this.portletAppDescriptor.getContainerRuntimeOption(portletID, "javax.portlet.actionScopedRequestAttributes");
        return containerRuntimeOption != null && "true".equals(containerRuntimeOption[0]);
    }

    private void setScopedAttributes(String actionScopeIDValue, PortletID portletID, PortletContainerRequest pcRequest, PortletRequest portletRequest) {
        Enumeration attributeNames = portletRequest.getAttributeNames();
        HashMap<String, Serializable> scopedAttributes = new HashMap<String, Serializable>();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (attributeName.startsWith("java.") || attributeName.startsWith("javax.") || attributeName.startsWith("com.sun.portal.portletcontainer.")) continue;
            Object value = portletRequest.getAttribute(attributeName);
            if (value instanceof Serializable) {
                scopedAttributes.put(attributeName, (Serializable)value);
                continue;
            }
            if (!logger.isLoggable(Level.WARNING)) continue;
            logger.log(Level.WARNING, "PSPL_PAECSPPA0026", value);
        }
        pcRequest.setScopedAttributes(actionScopeIDValue, scopedAttributes);
    }

    private Map<String, String[]> getUpdatedPublicRenderParameters(PortletConfig config, StateAwareResponse response) {
        Map renderParameters = response.getRenderParameterMap();
        HashMap<String, String[]> publicParameters = new HashMap<String, String[]>();
        Enumeration publicParameternames = config.getPublicRenderParameterNames();
        while (publicParameternames.hasMoreElements()) {
            String key = (String)publicParameternames.nextElement();
            String[] value = (String[])renderParameters.get(key);
            if (value == null) continue;
            publicParameters.put(key, value);
        }
        return publicParameters;
    }

    public void destroy() {
        ((LifecycleManagerImpl)this.lifecycleManager).destroy();
        ((RequestResponseFactoryImpl)this.requestResponseFactory).destroy();
        try {
            PortletDescriptorHolderFactory.getPortletDescriptorHolder().remove((Object)this.portletAppDescriptor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

