/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache;

import java.io.Closeable;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.oak.cache.AbstractCacheStats;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.time.Stopwatch;
import org.apache.jackrabbit.oak.segment.spi.RepositoryNotReachableException;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.PersistentCache;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.SegmentCacheStats;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistentCache
implements PersistentCache,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPersistentCache.class);
    public static final int THREADS = Integer.getInteger("oak.segment.cache.threads", 10);
    protected ExecutorService executor;
    protected AtomicLong cacheSize = new AtomicLong(0L);
    protected PersistentCache nextCache;
    protected final Set<String> writesPending;
    protected SegmentCacheStats segmentCacheStats;

    public AbstractPersistentCache() {
        this.executor = Executors.newFixedThreadPool(THREADS);
        this.writesPending = ConcurrentHashMap.newKeySet();
    }

    public PersistentCache linkWith(AbstractPersistentCache nextCache) {
        this.nextCache = nextCache;
        return nextCache;
    }

    @Override
    public Buffer readSegment(long msb, long lsb, @NotNull Callable<Buffer> loader) {
        Buffer segment = this.readSegmentInternal(msb, lsb);
        if (segment != null) {
            this.segmentCacheStats.hitCount.incrementAndGet();
            return segment;
        }
        this.segmentCacheStats.missCount.incrementAndGet();
        Callable<Buffer> nextLoader = this.nextCache != null ? () -> this.nextCache.readSegment(msb, lsb, loader) : loader;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            segment = nextLoader.call();
            if (segment != null) {
                this.recordCacheLoadTimeInternal(stopwatch.elapsed(TimeUnit.NANOSECONDS), true);
                this.writeSegment(msb, lsb, segment);
            }
            return segment;
        }
        catch (RepositoryNotReachableException e) {
            this.recordCacheLoadTimeInternal(stopwatch.elapsed(TimeUnit.NANOSECONDS), false);
            throw e;
        }
        catch (Exception t) {
            logger.error("Exception while loading segment {} from remote store or linked cache", (Object)new UUID(msb, lsb), (Object)t);
            this.recordCacheLoadTimeInternal(stopwatch.elapsed(TimeUnit.NANOSECONDS), false);
            return segment;
        }
    }

    protected abstract Buffer readSegmentInternal(long var1, long var3);

    protected final void recordCacheLoadTimeInternal(long loadTime, boolean successful) {
        if (successful) {
            this.segmentCacheStats.loadSuccessCount.incrementAndGet();
        } else {
            this.segmentCacheStats.loadExceptionCount.incrementAndGet();
        }
        this.segmentCacheStats.loadTime.addAndGet(loadTime);
    }

    @NotNull
    public AbstractCacheStats getCacheStats() {
        return this.segmentCacheStats;
    }

    @Override
    public void close() {
        try {
            this.executor.shutdown();
            if (this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                logger.debug("The persistent cache scheduler was successfully shut down");
            } else {
                logger.warn("The persistent cache scheduler takes too long to shut down");
            }
        }
        catch (InterruptedException e) {
            logger.warn("Interrupt while shutting down the persistent cache scheduler", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public int getWritesPending() {
        return this.writesPending.size();
    }
}

