/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.index;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.segment.file.tar.index.Index;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexEntryV2;

class IndexV2
implements Index {
    static final int FOOTER_SIZE = 16;
    private final Buffer entries;

    IndexV2(Buffer entries) {
        this.entries = entries;
    }

    @Override
    public Set<UUID> getUUIDs() {
        Set uuids = SetUtils.newHashSet((int)(this.entries.remaining() / 33));
        for (int position = this.entries.position(); position < this.entries.limit(); position += 33) {
            long msb = this.entries.getLong(position);
            long lsb = this.entries.getLong(position + 8);
            uuids.add(new UUID(msb, lsb));
        }
        return uuids;
    }

    @Override
    public int findEntry(long msb, long lsb) {
        int lowIndex = 0;
        int highIndex = this.entries.remaining() / 33 - 1;
        float lowValue = -9.223372E18f;
        float highValue = 9.223372E18f;
        float targetValue = msb;
        while (lowIndex <= highIndex) {
            int guessIndex = lowIndex + Math.round((float)(highIndex - lowIndex) * (targetValue - lowValue) / (highValue - lowValue));
            int position = this.entries.position() + guessIndex * 33;
            long m = this.entries.getLong(position);
            if (msb < m) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (msb > m) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            long l = this.entries.getLong(position + 8);
            if (lsb < l) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (lsb > l) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            return position / 33;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.entries.remaining() + 16;
    }

    @Override
    public int count() {
        return this.entries.remaining() / 33;
    }

    @Override
    public IndexEntryV2 entry(int i) {
        return new IndexEntryV2(this.entries, Objects.checkIndex(i, this.count()) * 33);
    }
}

