/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.segment.CommitsTracker;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreMonitor;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreStatsMBean;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SegmentNodeStoreStats
implements SegmentNodeStoreStatsMBean,
SegmentNodeStoreMonitor {
    private static final boolean COLLECT_STACK_TRACES = Boolean.parseBoolean(System.getProperty("oak.commitsTracker.collectStackTraces", "true"));
    private static final int OTHER_WRITERS_LIMIT = Integer.getInteger("oak.commitsTracker.otherWritersLimit", 20);
    public static final String COMMITS_COUNT = "COMMITS_COUNT";
    public static final String COMMIT_QUEUE_SIZE = "COMMIT_QUEUE_SIZE";
    public static final String COMMIT_TIME = "COMMIT_TIME";
    public static final String QUEUEING_TIME = "QUEUEING_TIME";
    private final StatisticsProvider statisticsProvider;
    private final MeterStats commitsCount;
    private final CounterStats commitQueueSize;
    private final TimerStats commitTime;
    private final TimerStats queueingTime;
    private volatile CommitsTracker commitsTracker;
    private boolean collectStackTraces = COLLECT_STACK_TRACES;
    private int otherWritersLimit = OTHER_WRITERS_LIMIT;
    private String[] writerGroups;

    public SegmentNodeStoreStats(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
        this.commitsTracker = new CommitsTracker(this.writerGroups, this.otherWritersLimit);
        this.commitsCount = statisticsProvider.getMeter(COMMITS_COUNT, StatsOptions.DEFAULT);
        this.commitQueueSize = statisticsProvider.getCounterStats(COMMIT_QUEUE_SIZE, StatsOptions.DEFAULT);
        this.commitTime = statisticsProvider.getTimer(COMMIT_TIME, StatsOptions.DEFAULT);
        this.queueingTime = statisticsProvider.getTimer(QUEUEING_TIME, StatsOptions.DEFAULT);
    }

    @Override
    public void onCommit(Thread t, long time) {
        this.commitsCount.mark();
        this.commitTime.update(time, TimeUnit.NANOSECONDS);
        this.commitsTracker.trackExecutedCommitOf(t);
    }

    @Override
    public void onCommitQueued(Thread t, Supplier<GCGeneration> gcGeneration) {
        this.commitQueueSize.inc();
        this.commitsTracker.trackQueuedCommitOf(t, gcGeneration);
    }

    @Override
    public void onCommitDequeued(Thread t, long time) {
        this.commitQueueSize.dec();
        this.queueingTime.update(time, TimeUnit.NANOSECONDS);
        this.commitsTracker.trackDequedCommitOf(t);
    }

    @Override
    public CompositeData getCommitsCount() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(COMMITS_COUNT), (String)COMMITS_COUNT);
    }

    @Override
    public CompositeData getQueuingCommitsCount() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(COMMIT_QUEUE_SIZE), (String)COMMIT_QUEUE_SIZE);
    }

    @Override
    public CompositeData getCommitTimes() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(COMMIT_TIME), (String)COMMIT_TIME);
    }

    @Override
    public CompositeData getQueuingTimes() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(QUEUEING_TIME), (String)QUEUEING_TIME);
    }

    @Override
    public TabularData getCommitsCountPerWriterGroupLastMinute() throws OpenDataException {
        return this.createTabularDataFromCountMap(this.commitsTracker.getCommitsCountPerGroupLastMinute(), "commitsPerWriterGroup", "writerGroup");
    }

    @Override
    public TabularData getCommitsCountForOtherWriters() throws OpenDataException {
        return this.createTabularDataFromCountMap(this.commitsTracker.getCommitsCountOthersLastMinute(), "commitsPerWriter", "writerName");
    }

    private TabularData createTabularDataFromCountMap(Map<String, Long> commitsCountMap, String typeName, String writerDescription) throws OpenDataException {
        CompositeType commitsPerWriterRowType = new CompositeType(typeName, typeName, new String[]{"count", writerDescription}, new String[]{"count", writerDescription}, new OpenType[]{SimpleType.LONG, SimpleType.STRING});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType(typeName, "Most active writers", commitsPerWriterRowType, new String[]{writerDescription}));
        Map<String, Long> map = commitsCountMap.isEmpty() ? Map.of("N/A", 0L) : commitsCountMap;
        map.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getValue).reversed()).map(e -> {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("count", e.getValue());
            m.put(writerDescription, e.getKey());
            return m;
        }).map(d -> SegmentNodeStoreStats.mapToCompositeData(commitsPerWriterRowType, d)).forEach(tabularData::put);
        return tabularData;
    }

    @NotNull
    private static CompositeType getCompositeType(String name) throws OpenDataException {
        return new CompositeType(name, name, new String[]{"writerName", "writerDetails", "GCGeneration", "queued", "dequeued", "applied"}, new String[]{"writerName", "writerDetails", "GCGeneration", "queued", "dequeued", "applied"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG});
    }

    @Override
    public TabularData getQueuedWriters() throws OpenDataException {
        CompositeType queuedWritersDetailsRowType = SegmentNodeStoreStats.getCompositeType("queuedWritersDetails");
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("queuedWritersDetails", "Queued writers details", queuedWritersDetailsRowType, new String[]{"writerName"}));
        this.commitsTracker.getQueuedWritersMap().values().stream().map(this::toMap).map(d -> SegmentNodeStoreStats.mapToCompositeData(queuedWritersDetailsRowType, d)).forEach(tabularData::put);
        return tabularData;
    }

    @Override
    @Nullable
    public CompositeData getCurrentWriter() throws OpenDataException {
        CommitsTracker.Commit writer = this.commitsTracker.getCurrentWriter();
        if (writer != null) {
            return SegmentNodeStoreStats.mapToCompositeData(SegmentNodeStoreStats.getCompositeType("currentWritersDetails"), this.toMap(writer));
        }
        return null;
    }

    @NotNull
    private Map<String, Object> toMap(@NotNull CommitsTracker.Commit commit) {
        return Map.of("writerName", commit.getThreadName(), "writerDetails", SegmentNodeStoreStats.toString(commit.getStackTrace()), "GCGeneration", SegmentNodeStoreStats.toString(commit.getGCGeneration()), "queued", commit.getQueued(), "dequeued", commit.getDequeued(), "applied", commit.getApplied());
    }

    @NotNull
    private static String toString(@Nullable StackTraceElement[] stackTrace) {
        if (stackTrace != null) {
            StringBuilder threadDetails = new StringBuilder();
            Stream.of(stackTrace).forEach(threadDetails::append);
            return threadDetails.toString();
        }
        return "N/A";
    }

    @NotNull
    private static String toString(@Nullable GCGeneration gcGeneration) {
        return gcGeneration == null ? "N/A" : gcGeneration.toString();
    }

    @Override
    public void setCollectStackTraces(boolean flag) {
        this.collectStackTraces = flag;
        this.commitsTracker = new CommitsTracker(this.writerGroups, this.otherWritersLimit);
    }

    @Override
    public boolean isCollectStackTraces() {
        return this.collectStackTraces;
    }

    @Override
    public int getNumberOfOtherWritersToDetail() {
        return this.otherWritersLimit;
    }

    @Override
    public void setNumberOfOtherWritersToDetail(int otherWritersLimit) {
        this.otherWritersLimit = otherWritersLimit;
        this.commitsTracker = new CommitsTracker(this.writerGroups, otherWritersLimit);
    }

    @Override
    public String[] getWriterGroupsForLastMinuteCounts() {
        return this.writerGroups;
    }

    @Override
    public void setWriterGroupsForLastMinuteCounts(String[] writerGroups) {
        this.writerGroups = writerGroups;
        this.commitsTracker = new CommitsTracker(writerGroups, this.otherWritersLimit);
    }

    private TimeSeries getTimeSeries(String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }

    private static CompositeData mapToCompositeData(CompositeType compositeType, Map<String, Object> data) {
        try {
            return new CompositeDataSupport(compositeType, data);
        }
        catch (ArrayStoreException | OpenDataException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

