/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.pio.Closer;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreRegistrar;
import org.apache.jackrabbit.oak.segment.spi.monitor.RoleStatisticsProvider;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.PersistentCache;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStoreProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(factory=true, ocd=Configuration.class)
public class SegmentNodeStoreFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long DEFAULT_BLOB_SNAPSHOT_INTERVAL = 43200L;
    private static final long DEFAULT_BLOB_GC_MAX_AGE = 86400L;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(!(split.blobstore=old))(!(split.blobstore=new)))")
    private volatile BlobStore blobStore;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile SegmentNodeStorePersistence segmentStore;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile PersistentCache persistentCache;
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    private final Closer registrations = Closer.create();

    @Activate
    public void activate(ComponentContext context, Configuration configuration) throws IOException {
        this.log.info("activate: SegmentNodeStore '" + configuration.role() + "' starting.");
        if (configuration.role().isEmpty()) {
            return;
        }
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(context.getBundleContext());
        SegmentNodeStore store = SegmentNodeStoreFactory.registerSegmentStore(context, configuration, this.blobStore, this.segmentStore, this.persistentCache, SegmentNodeStoreFactory.getRoleStatisticsProvider(this.statisticsProvider, configuration.role()), this.registrations, (Whiteboard)whiteboard, configuration.role(), this.log);
        if (store == null) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("role", configuration.role());
        this.registrations.register(SegmentNodeStoreFactory.asCloseable(whiteboard.register(NodeStoreProvider.class, () -> store, props)));
        this.log.info("Registered NodeStoreProvider backed by SegmentNodeStore of type '{}'", (Object)configuration.role());
    }

    @Deactivate
    public void deactivate() {
        IOUtils.closeQuietly((Closeable)this.registrations);
    }

    private static Closeable asCloseable(final Registration r) {
        return new Closeable(){

            @Override
            public void close() {
                r.unregister();
            }
        };
    }

    static String property(String name, ComponentContext context) {
        return OsgiUtil.lookupConfigurationThenFramework((ComponentContext)context, (String)name);
    }

    private static SegmentNodeStore registerSegmentStore(final ComponentContext context, final Configuration configuration, final BlobStore blobStore, final SegmentNodeStorePersistence segmentStore, final PersistentCache persistentCache, final StatisticsProvider statisticsProvider, final Closer closer, final Whiteboard whiteboard, final String role, final Logger logger) throws IOException {
        return SegmentNodeStoreRegistrar.registerSegmentNodeStore(new SegmentNodeStoreRegistrar.Configuration(){

            String appendRole(String name) {
                return name + "-" + role;
            }

            int roundToNextPowerOfTwo(int size) {
                return 1 << 32 - Integer.numberOfLeadingZeros(Math.max(0, size - 1));
            }

            String getMode() {
                String mode = configuration.tarmk_mode();
                if (Objects.toString(mode, "").isEmpty()) {
                    return System.getProperty("tarmk.mode", System.getProperty("sun.arch.data.model", "32"));
                }
                return mode;
            }

            int getCacheSize(String name, int otherwise) {
                Integer size = Integer.getInteger(name);
                if (size != null) {
                    return size;
                }
                return otherwise;
            }

            @Override
            public boolean isPrimarySegmentStore() {
                return false;
            }

            @Override
            public boolean isSecondarySegmentStore() {
                return "secondary".equals(role);
            }

            @Override
            public boolean isStandbyInstance() {
                return configuration.standby();
            }

            @Override
            public String getRole() {
                return role;
            }

            @Override
            public int getRetainedGenerations() {
                return configuration.compaction_retainedGenerations();
            }

            @Override
            public int getDefaultRetainedGenerations() {
                return 2;
            }

            @Override
            public boolean getPauseCompaction() {
                return configuration.pauseCompaction();
            }

            @Override
            public int getRetryCount() {
                return configuration.compaction_retryCount();
            }

            @Override
            public int getForceCompactionTimeout() {
                return configuration.compaction_force_timeout();
            }

            @Override
            public long getSizeDeltaEstimation() {
                return configuration.compaction_sizeDeltaEstimation();
            }

            @Override
            public int getMemoryThreshold() {
                return configuration.compaction_memoryThreshold();
            }

            @Override
            public boolean getDisableEstimation() {
                return configuration.compaction_disableEstimation();
            }

            @Override
            public long getGCProcessLog() {
                return configuration.compaction_progressLog();
            }

            @Override
            public File getSegmentDirectory() {
                return new File(this.getRepositoryHome(), this.appendRole("segmentstore"));
            }

            @Override
            public File getSplitPersistenceDirectory() {
                return new File(this.getRepositoryHome(), this.appendRole("segmentstore-split"));
            }

            @Override
            public int getSegmentCacheSize() {
                return this.getCacheSize("segmentCache.size", configuration.segmentCache_size());
            }

            @Override
            public int getStringCacheSize() {
                return this.getCacheSize("stringCache.size", configuration.stringCache_size());
            }

            @Override
            public int getTemplateCacheSize() {
                return this.getCacheSize("templateCache.size", configuration.templateCache_size());
            }

            @Override
            public int getStringDeduplicationCacheSize() {
                return this.getCacheSize("stringDeduplicationCache.size", configuration.stringDeduplicationCache_size());
            }

            @Override
            public int getTemplateDeduplicationCacheSize() {
                return this.getCacheSize("templateDeduplicationCache.size", configuration.templateDeduplicationCache_size());
            }

            @Override
            public int getNodeDeduplicationCacheSize() {
                return this.roundToNextPowerOfTwo(this.getCacheSize("nodeDeduplicationCache.size", configuration.nodeDeduplicationCache_size()));
            }

            @Override
            public int getMaxFileSize() {
                return configuration.tarmk_size();
            }

            @Override
            public boolean getMemoryMapping() {
                return this.getMode().equals("64");
            }

            @Override
            public boolean hasCustomBlobStore() {
                return configuration.customBlobStore();
            }

            @Override
            public boolean hasCustomSegmentStore() {
                return configuration.customSegmentStore();
            }

            @Override
            public boolean hasSplitPersistence() {
                return configuration.splitPersistence();
            }

            @Override
            public boolean hasCachePersistence() {
                return configuration.cachePersistence();
            }

            @Override
            public boolean registerDescriptors() {
                return configuration.registerDescriptors();
            }

            @Override
            public boolean dispatchChanges() {
                return configuration.dispatchChanges();
            }

            @Override
            public String getRepositoryHome() {
                String repositoryHome = OsgiUtil.lookupConfigurationThenFramework((ComponentContext)context, (String)"repository.home");
                if (Objects.toString(repositoryHome, "").isEmpty()) {
                    return "repository";
                }
                return repositoryHome;
            }

            @Override
            public long getBlobSnapshotInterval() {
                return configuration.blobTrackSnapshotIntervalInSecs();
            }

            @Override
            public long getBlobGcMaxAge() {
                return configuration.blobGcMaxAgeInSecs();
            }

            @Override
            public File getBackupDirectory() {
                String backupDirectory = configuration.repository_backup_dir();
                if (Objects.toString(backupDirectory, "").isEmpty()) {
                    return new File(this.getRepositoryHome(), this.appendRole("segmentstore-backup"));
                }
                return new File(backupDirectory);
            }

            @Override
            public Whiteboard getWhiteboard() {
                return whiteboard;
            }

            @Override
            public Closer getCloser() {
                return closer;
            }

            @Override
            public Logger getLogger() {
                return logger;
            }

            @Override
            public StatisticsProvider getStatisticsProvider() {
                return statisticsProvider;
            }

            @Override
            public BlobStore getBlobStore() {
                return blobStore;
            }

            @Override
            public SegmentNodeStorePersistence getSegmentNodeStorePersistence() {
                return segmentStore;
            }

            @Override
            public PersistentCache getPersistentCache() {
                return persistentCache;
            }

            @Override
            public BundleContext getBundleContext() {
                return context.getBundleContext();
            }
        });
    }

    private static StatisticsProvider getRoleStatisticsProvider(StatisticsProvider delegate, String role) {
        return new RoleStatisticsProvider(delegate, role);
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak Segment-Tar NodeStore Factory", description="Factory allowing configuration of adjacent instances of NodeStore implementation based on Segment model besides a default SegmentNodeStore in same setup.")
    static @interface Configuration {
        @AttributeDefinition(name="Repository Home Directory", description="Path on the file system where repository data will be stored. Defaults to the value of the framework property 'repository.home' or to 'repository' if that is neither specified.")
        public String repository_home() default "";

        @AttributeDefinition(name="Mode", description="TarMK mode (64 for memory mapped file access, 32 for normal file access). Default value is taken from the 'sun.arch.data.model' system property.")
        public String tarmk_mode() default "";

        @AttributeDefinition(name="Maximum tar file size (MB)", description="The maximum size of the tar files in megabytes. Default value is '256'.")
        public int tarmk_size() default 256;

        @AttributeDefinition(name="Segment cache size (MB)", description="Cache size for storing most recently used segments in megabytes. Default value is '256'.")
        public int segmentCache_size() default 256;

        @AttributeDefinition(name="String cache size (MB)", description="Cache size for storing most recently used strings in megabytes. Default value is '256'.")
        public int stringCache_size() default 256;

        @AttributeDefinition(name="Template cache size (MB)", description="Cache size for storing most recently used templates in megabytes. Default value is '64'.")
        public int templateCache_size() default 64;

        @AttributeDefinition(name="String deduplication cache size (#items)", description="Maximum number of strings to keep in the deduplication cache. Default value is '15000'.")
        public int stringDeduplicationCache_size() default 15000;

        @AttributeDefinition(name="Template deduplication cache size (#items)", description="Maximum number of templates to keep in the deduplication cache. Default value is '3000'.")
        public int templateDeduplicationCache_size() default 3000;

        @AttributeDefinition(name="Node deduplication cache size (#items)", description="Maximum number of node to keep in the deduplication cache. If the supplied value is not a power of 2, it will be rounded up to the next power of 2. Default value is '1048576'.")
        public int nodeDeduplicationCache_size() default 0x100000;

        @AttributeDefinition(name="Pause compaction", description="When set to true the compaction phase is skipped during garbage collection. Default value is 'false'.")
        public boolean pauseCompaction() default false;

        @AttributeDefinition(name="Compaction retries", description="Number of tries to compact concurrent commits on top of already compacted commits. Default value is '5'.")
        public int compaction_retryCount() default 5;

        @AttributeDefinition(name="Force compaction timeout", description="Number of seconds to attempt to force compact concurrent commits on top of already compacted commits after the maximum number of retries has been reached. Forced compaction tries to acquire an exclusive write lock on the node store, blocking concurrent write access as long as the lock is held. Default value is '60'.")
        public int compaction_force_timeout() default 60;

        @AttributeDefinition(name="Garbage collection repository size threshold", description="Garbage collection will be skipped unless the repository grew at least by the number of bytes specified. Default value is '1073741824'.")
        public long compaction_sizeDeltaEstimation() default 0x40000000L;

        @AttributeDefinition(name="Disable estimation phase", description="Disables the estimation phase allowing garbage collection to run unconditionally. Default value is 'false'.")
        public boolean compaction_disableEstimation() default false;

        @AttributeDefinition(name="Compaction retained generations", description="Number of segment generations to retain during garbage collection. The number of generations defaults to 2 and can't be changed. This configuration option is considered deprecated and will be removed in the future.")
        public int compaction_retainedGenerations() default 2;

        @AttributeDefinition(name="Compaction memory threshold", description="Threshold of available heap memory in percent of total heap memory below which the compaction phase is canceled. 0 disables heap memory monitoring. Default value is '15'.")
        public int compaction_memoryThreshold() default 15;

        @AttributeDefinition(name="Compaction progress log", description="The number of nodes compacted after which a status message is logged. -1 disables progress logging. Default value is '-1'.")
        public long compaction_progressLog() default -1L;

        @AttributeDefinition(name="Standby mode", description="Flag indicating this component will not register as a NodeStore but as a NodeStoreProvider instead. Default value is 'false'.")
        public boolean standby() default false;

        @AttributeDefinition(name="Custom blob store", description="Boolean value indicating that a custom BlobStore is used for storing large binary values.")
        public boolean customBlobStore() default false;

        @AttributeDefinition(name="Custom segment store", description="Boolean value indicating that a custom (non-tar) segment store is used")
        public boolean customSegmentStore() default false;

        @AttributeDefinition(name="Split persistence", description="Boolean value indicating that the writes should be done locally when using the custom segment store")
        public boolean splitPersistence() default false;

        @AttributeDefinition(name="Cache persistence", description="Boolean value indicating that the persisted cache should be used for the custom segment store")
        public boolean cachePersistence() default false;

        @AttributeDefinition(name="Backup directory", description="Directory (relative to current working directory) for storing repository backups. Defaults to 'repository.home/segmentstore-backup'.")
        public String repository_backup_dir() default "";

        @AttributeDefinition(name="Blob gc max age (in secs)", description="The blob garbage collection logic will only consider those blobs which are not accessed recently (currentTime - lastModifiedTime > blobGcMaxAgeInSecs). For example with the default setting only those blobs which have been created at least 24 hours ago will be considered for garbage collection. Default value is '86400'.")
        public long blobGcMaxAgeInSecs() default 86400L;

        @AttributeDefinition(name="Blob tracking snapshot interval", description="Interval in seconds in which snapshots of locally tracked blob ids are taken and synchronized with the blob store. This should be configured to be less than the frequency of blob garbage collection so that deletions during blob garbage collection can be accounted for in the next garbage collection execution. Default value is '43200'.")
        public long blobTrackSnapshotIntervalInSecs() default 43200L;

        @AttributeDefinition(name="Role", description="As multiple SegmentNodeStores can be configured, this parameter defines the role of 'this' SegmentNodeStore.")
        public String role() default "";

        @AttributeDefinition(name="Register JCR descriptors as OSGi services", description="Should only be done for one factory instance")
        public boolean registerDescriptors() default false;

        @AttributeDefinition(name="Dispatch changes", description="Enable support for observers on this factory instance")
        public boolean dispatchChanges() default false;
    }
}

